/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines whether a service deployment fails if a service cannot reach a steady state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder, AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails> {
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enable").getter(getter(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails::enable))
            .setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enable").build()).build();

    private static final SdkField<Boolean> ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Rollback").getter(getter(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails::rollback))
            .setter(setter(Builder::rollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rollback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_FIELD, ROLLBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enable;

    private final Boolean rollback;

    private AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(BuilderImpl builder) {
        this.enable = builder.enable;
        this.rollback = builder.rollback;
    }

    /**
     * <p>
     * Whether to enable the deployment circuit breaker logic for the service.
     * </p>
     * 
     * @return Whether to enable the deployment circuit breaker logic for the service.
     */
    public final Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment
     * fails, the service is rolled back to the last deployment that completed successfully.
     * </p>
     * 
     * @return Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service
     *         deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    public final Boolean rollback() {
        return rollback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        hashCode = 31 * hashCode + Objects.hashCode(rollback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)) {
            return false;
        }
        AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails other = (AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) obj;
        return Objects.equals(enable(), other.enable()) && Objects.equals(rollback(), other.rollback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails").add("Enable", enable())
                .add("Rollback", rollback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        case "Rollback":
            return Optional.ofNullable(clazz.cast(rollback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails> {
        /**
         * <p>
         * Whether to enable the deployment circuit breaker logic for the service.
         * </p>
         * 
         * @param enable
         *        Whether to enable the deployment circuit breaker logic for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service
         * deployment fails, the service is rolled back to the last deployment that completed successfully.
         * </p>
         * 
         * @param rollback
         *        Whether to roll back the service if a service deployment fails. If rollback is enabled, when a service
         *        deployment fails, the service is rolled back to the last deployment that completed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollback(Boolean rollback);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enable;

        private Boolean rollback;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails model) {
            enable(model.enable);
            rollback(model.rollback);
        }

        public final Boolean getEnable() {
            return enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final Boolean getRollback() {
            return rollback;
        }

        public final void setRollback(Boolean rollback) {
            this.rollback = rollback;
        }

        @Override
        public final Builder rollback(Boolean rollback) {
            this.rollback = rollback;
            return this;
        }

        @Override
        public AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails build() {
            return new AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
