/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFindingsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<BatchUpdateFindingsResponse.Builder, BatchUpdateFindingsResponse> {
    private static final SdkField<List<AwsSecurityFindingIdentifier>> PROCESSED_FINDINGS_FIELD = SdkField
            .<List<AwsSecurityFindingIdentifier>> builder(MarshallingType.LIST)
            .memberName("ProcessedFindings")
            .getter(getter(BatchUpdateFindingsResponse::processedFindings))
            .setter(setter(Builder::processedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsSecurityFindingIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsSecurityFindingIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateFindingsUnprocessedFinding>> UNPROCESSED_FINDINGS_FIELD = SdkField
            .<List<BatchUpdateFindingsUnprocessedFinding>> builder(MarshallingType.LIST)
            .memberName("UnprocessedFindings")
            .getter(getter(BatchUpdateFindingsResponse::unprocessedFindings))
            .setter(setter(Builder::unprocessedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFindingsUnprocessedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFindingsUnprocessedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_FINDINGS_FIELD,
            UNPROCESSED_FINDINGS_FIELD));

    private final List<AwsSecurityFindingIdentifier> processedFindings;

    private final List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings;

    private BatchUpdateFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.processedFindings = builder.processedFindings;
        this.unprocessedFindings = builder.unprocessedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessedFindings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessedFindings() {
        return processedFindings != null && !(processedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of findings that were updated successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessedFindings} method.
     * </p>
     * 
     * @return The list of findings that were updated successfully.
     */
    public final List<AwsSecurityFindingIdentifier> processedFindings() {
        return processedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedFindings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedFindings() {
        return unprocessedFindings != null && !(unprocessedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of findings that were not updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedFindings} method.
     * </p>
     * 
     * @return The list of findings that were not updated.
     */
    public final List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings() {
        return unprocessedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedFindings() ? processedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedFindings() ? unprocessedFindings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsResponse)) {
            return false;
        }
        BatchUpdateFindingsResponse other = (BatchUpdateFindingsResponse) obj;
        return hasProcessedFindings() == other.hasProcessedFindings()
                && Objects.equals(processedFindings(), other.processedFindings())
                && hasUnprocessedFindings() == other.hasUnprocessedFindings()
                && Objects.equals(unprocessedFindings(), other.unprocessedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFindingsResponse")
                .add("ProcessedFindings", hasProcessedFindings() ? processedFindings() : null)
                .add("UnprocessedFindings", hasUnprocessedFindings() ? unprocessedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedFindings":
            return Optional.ofNullable(clazz.cast(processedFindings()));
        case "UnprocessedFindings":
            return Optional.ofNullable(clazz.cast(unprocessedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsResponse, T> g) {
        return obj -> g.apply((BatchUpdateFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateFindingsResponse> {
        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * 
         * @param processedFindings
         *        The list of findings that were updated successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedFindings(Collection<AwsSecurityFindingIdentifier> processedFindings);

        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * 
         * @param processedFindings
         *        The list of findings that were updated successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedFindings(AwsSecurityFindingIdentifier... processedFindings);

        /**
         * <p>
         * The list of findings that were updated successfully.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier.Builder#build()} is
         * called immediately and its result is passed to {@link #processedFindings(List<AwsSecurityFindingIdentifier>)}.
         * 
         * @param processedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processedFindings(java.util.Collection<AwsSecurityFindingIdentifier>)
         */
        Builder processedFindings(Consumer<AwsSecurityFindingIdentifier.Builder>... processedFindings);

        /**
         * <p>
         * The list of findings that were not updated.
         * </p>
         * 
         * @param unprocessedFindings
         *        The list of findings that were not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings);

        /**
         * <p>
         * The list of findings that were not updated.
         * </p>
         * 
         * @param unprocessedFindings
         *        The list of findings that were not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedFindings(BatchUpdateFindingsUnprocessedFinding... unprocessedFindings);

        /**
         * <p>
         * The list of findings that were not updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedFindings(List<BatchUpdateFindingsUnprocessedFinding>)}.
         * 
         * @param unprocessedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedFindings(java.util.Collection<BatchUpdateFindingsUnprocessedFinding>)
         */
        Builder unprocessedFindings(Consumer<BatchUpdateFindingsUnprocessedFinding.Builder>... unprocessedFindings);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<AwsSecurityFindingIdentifier> processedFindings = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsResponse model) {
            super(model);
            processedFindings(model.processedFindings);
            unprocessedFindings(model.unprocessedFindings);
        }

        public final List<AwsSecurityFindingIdentifier.Builder> getProcessedFindings() {
            List<AwsSecurityFindingIdentifier.Builder> result = AwsSecurityFindingIdentifierListCopier
                    .copyToBuilder(this.processedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedFindings(Collection<AwsSecurityFindingIdentifier.BuilderImpl> processedFindings) {
            this.processedFindings = AwsSecurityFindingIdentifierListCopier.copyFromBuilder(processedFindings);
        }

        @Override
        public final Builder processedFindings(Collection<AwsSecurityFindingIdentifier> processedFindings) {
            this.processedFindings = AwsSecurityFindingIdentifierListCopier.copy(processedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(AwsSecurityFindingIdentifier... processedFindings) {
            processedFindings(Arrays.asList(processedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(Consumer<AwsSecurityFindingIdentifier.Builder>... processedFindings) {
            processedFindings(Stream.of(processedFindings)
                    .map(c -> AwsSecurityFindingIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateFindingsUnprocessedFinding.Builder> getUnprocessedFindings() {
            List<BatchUpdateFindingsUnprocessedFinding.Builder> result = BatchUpdateFindingsUnprocessedFindingsListCopier
                    .copyToBuilder(this.unprocessedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding.BuilderImpl> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsUnprocessedFindingsListCopier.copyFromBuilder(unprocessedFindings);
        }

        @Override
        public final Builder unprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsUnprocessedFindingsListCopier.copy(unprocessedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(BatchUpdateFindingsUnprocessedFinding... unprocessedFindings) {
            unprocessedFindings(Arrays.asList(unprocessedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(Consumer<BatchUpdateFindingsUnprocessedFinding.Builder>... unprocessedFindings) {
            unprocessedFindings(Stream.of(unprocessedFindings)
                    .map(c -> BatchUpdateFindingsUnprocessedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateFindingsResponse build() {
            return new BatchUpdateFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
