/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the association between an Security Hub configuration and a target account, organizational
 * unit, or the root. An association can exist between a target and a configuration policy, or between a target and
 * self-managed behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationPolicyAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationPolicyAssociation.Builder, ConfigurationPolicyAssociation> {
    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(ConfigurationPolicyAssociation::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Target target;

    private ConfigurationPolicyAssociation(BuilderImpl builder) {
        this.target = builder.target;
    }

    /**
     * <p>
     * The target account, organizational unit, or the root.
     * </p>
     * 
     * @return The target account, organizational unit, or the root.
     */
    public final Target target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationPolicyAssociation)) {
            return false;
        }
        ConfigurationPolicyAssociation other = (ConfigurationPolicyAssociation) obj;
        return Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationPolicyAssociation").add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationPolicyAssociation, T> g) {
        return obj -> g.apply((ConfigurationPolicyAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationPolicyAssociation> {
        /**
         * <p>
         * The target account, organizational unit, or the root.
         * </p>
         * 
         * @param target
         *        The target account, organizational unit, or the root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The target account, organizational unit, or the root.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Target target;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationPolicyAssociation model) {
            target(model.target);
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        @Override
        public ConfigurationPolicyAssociation build() {
            return new ConfigurationPolicyAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
