/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UnshareApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesPublisher;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsPublisher;
import software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher;

/**
 * Service client for accessing AWSServerlessApplicationRepository asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Serverless Application Repository makes it easy for developers and enterprises to quickly find and deploy
 * serverless applications in the AWS Cloud. For more information about serverless applications, see Serverless
 * Computing and Applications on the AWS website.
 * </p>
 * <p>
 * The AWS Serverless Application Repository is deeply integrated with the AWS Lambda console, so that developers of all
 * levels can get started with serverless computing without needing to learn anything new. You can use category keywords
 * to browse for applications such as web and mobile backends, data processing applications, or chatbots. You can also
 * search for applications by name, publisher, or event source. To use an application, you simply choose it, configure
 * any required fields, and deploy it with a few clicks.
 * </p>
 * <p>
 * You can also easily publish applications, sharing them publicly with the community at large, or privately within your
 * team or across your organization. To publish a serverless application (or app), you can use the AWS Management
 * Console, AWS Command Line Interface (AWS CLI), or AWS SDKs to upload the code. Along with the code, you upload a
 * simple manifest file, also known as the AWS Serverless Application Model (AWS SAM) template. For more information
 * about AWS SAM, see AWS Serverless Application Model (AWS SAM) on the AWS Labs GitHub repository.
 * </p>
 * <p>
 * The AWS Serverless Application Repository Developer Guide contains more information about the two developer
 * experiences available:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Consuming Applications – Browse for applications and view information about them, including source code and readme
 * files. Also install, configure, and deploy applications of your choosing.
 * </p>
 * <p>
 * Publishing Applications – Configure and upload applications to make them available to other developers, and publish
 * new versions of applications.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServerlessApplicationRepositoryAsyncClient extends SdkClient {
    String SERVICE_NAME = "serverlessrepo";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "serverlessrepo";

    /**
     * Create a {@link ServerlessApplicationRepositoryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServerlessApplicationRepositoryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServerlessApplicationRepositoryAsyncClient}.
     */
    static ServerlessApplicationRepositoryAsyncClientBuilder builder() {
        return new DefaultServerlessApplicationRepositoryAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an application version.
     * </p>
     *
     * @param createApplicationVersionRequest
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            Consumer<CreateApplicationVersionRequest.Builder> createApplicationVersionRequest) {
        return createApplicationVersion(CreateApplicationVersionRequest.builder().applyMutation(createApplicationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS CloudFormation change set for the given application.
     * </p>
     *
     * @param createCloudFormationChangeSetRequest
     * @return A Java Future containing the result of the CreateCloudFormationChangeSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationChangeSetResponse> createCloudFormationChangeSet(
            CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS CloudFormation change set for the given application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationChangeSetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudFormationChangeSetRequest#builder()}
     * </p>
     *
     * @param createCloudFormationChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFormationChangeSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCloudFormationChangeSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationChangeSetResponse> createCloudFormationChangeSet(
            Consumer<CreateCloudFormationChangeSetRequest.Builder> createCloudFormationChangeSetRequest) {
        return createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest.builder()
                .applyMutation(createCloudFormationChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates an AWS CloudFormation template.
     * </p>
     *
     * @param createCloudFormationTemplateRequest
     * @return A Java Future containing the result of the CreateCloudFormationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationTemplateResponse> createCloudFormationTemplate(
            CreateCloudFormationTemplateRequest createCloudFormationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS CloudFormation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudFormationTemplateRequest#builder()}
     * </p>
     *
     * @param createCloudFormationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFormationTemplateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCloudFormationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationTemplateResponse> createCloudFormationTemplate(
            Consumer<CreateCloudFormationTemplateRequest.Builder> createCloudFormationTemplateRequest) {
        return createCloudFormationTemplate(CreateCloudFormationTemplateRequest.builder()
                .applyMutation(createCloudFormationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Gets the specified application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves the policy for the application.
     * </p>
     *
     * @param getApplicationPolicyRequest
     * @return A Java Future containing the result of the GetApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationPolicyResponse> getApplicationPolicy(
            GetApplicationPolicyRequest getApplicationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the policy for the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationPolicyRequest#builder()}
     * </p>
     *
     * @param getApplicationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationPolicyResponse> getApplicationPolicy(
            Consumer<GetApplicationPolicyRequest.Builder> getApplicationPolicyRequest) {
        return getApplicationPolicy(GetApplicationPolicyRequest.builder().applyMutation(getApplicationPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the specified AWS CloudFormation template.
     * </p>
     *
     * @param getCloudFormationTemplateRequest
     * @return A Java Future containing the result of the GetCloudFormationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFormationTemplateResponse> getCloudFormationTemplate(
            GetCloudFormationTemplateRequest getCloudFormationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified AWS CloudFormation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFormationTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetCloudFormationTemplateRequest#builder()}
     * </p>
     *
     * @param getCloudFormationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetCloudFormationTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCloudFormationTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetCloudFormationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetCloudFormationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFormationTemplateResponse> getCloudFormationTemplate(
            Consumer<GetCloudFormationTemplateRequest.Builder> getCloudFormationTemplateRequest) {
        return getCloudFormationTemplate(GetCloudFormationTemplateRequest.builder()
                .applyMutation(getCloudFormationTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     *
     * @param listApplicationDependenciesRequest
     * @return A Java Future containing the result of the ListApplicationDependencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationDependenciesResponse> listApplicationDependencies(
            ListApplicationDependenciesRequest listApplicationDependenciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationDependenciesRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationDependenciesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListApplicationDependencies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationDependenciesResponse> listApplicationDependencies(
            Consumer<ListApplicationDependenciesRequest.Builder> listApplicationDependenciesRequest) {
        return listApplicationDependencies(ListApplicationDependenciesRequest.builder()
                .applyMutation(listApplicationDependenciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesPublisher publisher = client.listApplicationDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesPublisher publisher = client.listApplicationDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationDependenciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesPublisher listApplicationDependenciesPaginator(
            ListApplicationDependenciesRequest listApplicationDependenciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of applications nested in the containing application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesPublisher publisher = client.listApplicationDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationDependenciesPublisher publisher = client.listApplicationDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDependencies(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationDependenciesRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationDependenciesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDependenciesPublisher listApplicationDependenciesPaginator(
            Consumer<ListApplicationDependenciesRequest.Builder> listApplicationDependenciesRequest) {
        return listApplicationDependenciesPaginator(ListApplicationDependenciesRequest.builder()
                .applyMutation(listApplicationDependenciesRequest).build());
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().applyMutation(listApplicationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsPublisher listApplicationVersionsPaginator(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists versions for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsPublisher listApplicationVersionsPaginator(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersionsPaginator(ListApplicationVersionsRequest.builder()
                .applyMutation(listApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     *
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications() {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator() {
        return listApplicationsPaginator(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists applications owned by the requester.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.serverlessapplicationrepository.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Sets the permission policy for an application. For the list of actions supported for this operation, see <a href=
     * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     * >Application Permissions</a> .
     * </p>
     *
     * @param putApplicationPolicyRequest
     * @return A Java Future containing the result of the PutApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.PutApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationPolicyResponse> putApplicationPolicy(
            PutApplicationPolicyRequest putApplicationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the permission policy for an application. For the list of actions supported for this operation, see <a href=
     * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     * >Application Permissions</a> .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutApplicationPolicyRequest#builder()}
     * </p>
     *
     * @param putApplicationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutApplicationPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.PutApplicationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationPolicyResponse> putApplicationPolicy(
            Consumer<PutApplicationPolicyRequest.Builder> putApplicationPolicyRequest) {
        return putApplicationPolicy(PutApplicationPolicyRequest.builder().applyMutation(putApplicationPolicyRequest).build());
    }

    /**
     * <p>
     * Unshares an application from an AWS Organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's master account.
     * </p>
     *
     * @param unshareApplicationRequest
     * @return A Java Future containing the result of the UnshareApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UnshareApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UnshareApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnshareApplicationResponse> unshareApplication(UnshareApplicationRequest unshareApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unshares an application from an AWS Organization.
     * </p>
     * <p>
     * This operation can be called only from the organization's master account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnshareApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UnshareApplicationRequest#builder()}
     * </p>
     *
     * @param unshareApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UnshareApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnshareApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UnshareApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UnshareApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UnshareApplicationResponse> unshareApplication(
            Consumer<UnshareApplicationRequest.Builder> unshareApplicationRequest) {
        return unshareApplication(UnshareApplicationRequest.builder().applyMutation(unshareApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>InternalServerErrorException The AWS Serverless Application Repository service encountered an
     *         internal error.</li>
     *         <li>ForbiddenException The client is not authenticated.</li>
     *         <li>NotFoundException The resource (for example, an access policy statement) specified in the request
     *         doesn't exist.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }
}
