/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedProductPlanDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedProductPlanDetails.Builder, ProvisionedProductPlanDetails> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ProvisionedProductPlanDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PathId")
            .getter(getter(ProvisionedProductPlanDetails::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ProvisionedProductPlanDetails::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlanName").getter(getter(ProvisionedProductPlanDetails::planName)).setter(setter(Builder::planName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()).build();

    private static final SdkField<String> PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PlanId")
            .getter(getter(ProvisionedProductPlanDetails::planId)).setter(setter(Builder::planId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()).build();

    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionProductId").getter(getter(ProvisionedProductPlanDetails::provisionProductId))
            .setter(setter(Builder::provisionProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build())
            .build();

    private static final SdkField<String> PROVISION_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionProductName").getter(getter(ProvisionedProductPlanDetails::provisionProductName))
            .setter(setter(Builder::provisionProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductName").build())
            .build();

    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlanType").getter(getter(ProvisionedProductPlanDetails::planTypeAsString))
            .setter(setter(Builder::planType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanType").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(ProvisionedProductPlanDetails::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProvisionedProductPlanDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTime").getter(getter(ProvisionedProductPlanDetails::updatedTime))
            .setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationArns")
            .getter(getter(ProvisionedProductPlanDetails::notificationArns))
            .setter(setter(Builder::notificationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UpdateProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<UpdateProvisioningParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningParameters")
            .getter(getter(ProvisionedProductPlanDetails::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ProvisionedProductPlanDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProvisionedProductPlanDetails::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            PATH_ID_FIELD, PRODUCT_ID_FIELD, PLAN_NAME_FIELD, PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD,
            PROVISION_PRODUCT_NAME_FIELD, PLAN_TYPE_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, STATUS_FIELD, UPDATED_TIME_FIELD,
            NOTIFICATION_ARNS_FIELD, PROVISIONING_PARAMETERS_FIELD, TAGS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdTime;

    private final String pathId;

    private final String productId;

    private final String planName;

    private final String planId;

    private final String provisionProductId;

    private final String provisionProductName;

    private final String planType;

    private final String provisioningArtifactId;

    private final String status;

    private final Instant updatedTime;

    private final List<String> notificationArns;

    private final List<UpdateProvisioningParameter> provisioningParameters;

    private final List<Tag> tags;

    private final String statusMessage;

    private ProvisionedProductPlanDetails(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.pathId = builder.pathId;
        this.productId = builder.productId;
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionProductName = builder.provisionProductName;
        this.planType = builder.planType;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.status = builder.status;
        this.updatedTime = builder.updatedTime;
        this.notificationArns = builder.notificationArns;
        this.provisioningParameters = builder.provisioningParameters;
        this.tags = builder.tags;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The UTC time stamp of the creation time.
     * </p>
     * 
     * @return The UTC time stamp of the creation time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The path identifier of the product. This value is optional if the product has a default path, and required if the
     * product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>.
     * </p>
     * 
     * @return The path identifier of the product. This value is optional if the product has a default path, and
     *         required if the product has more than one path. To list the paths for a product, use
     *         <a>ListLaunchPaths</a>.
     */
    public final String pathId() {
        return pathId;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The name of the plan.
     * </p>
     * 
     * @return The name of the plan.
     */
    public final String planName() {
        return planName;
    }

    /**
     * <p>
     * The plan identifier.
     * </p>
     * 
     * @return The plan identifier.
     */
    public final String planId() {
        return planId;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String provisionProductId() {
        return provisionProductId;
    }

    /**
     * <p>
     * The user-friendly name of the provisioned product.
     * </p>
     * 
     * @return The user-friendly name of the provisioned product.
     */
    public final String provisionProductName() {
        return provisionProductName;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link ProvisionedProductPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see ProvisionedProductPlanType
     */
    public final ProvisionedProductPlanType planType() {
        return ProvisionedProductPlanType.fromValue(planType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link ProvisionedProductPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see ProvisionedProductPlanType
     */
    public final String planTypeAsString() {
        return planType;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedProductPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see ProvisionedProductPlanStatus
     */
    public final ProvisionedProductPlanStatus status() {
        return ProvisionedProductPlanStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedProductPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see ProvisionedProductPlanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the plan was last updated.
     * </p>
     * 
     * @return The time when the plan was last updated.
     */
    public final Instant updatedTime() {
        return updatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationArns() {
        return notificationArns != null && !(notificationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationArns} method.
     * </p>
     * 
     * @return Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    public final List<String> notificationArns() {
        return notificationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters specified by the administrator that are required for provisioning the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningParameters} method.
     * </p>
     * 
     * @return Parameters specified by the administrator that are required for provisioning the product.
     */
    public final List<UpdateProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(planName());
        hashCode = 31 * hashCode + Objects.hashCode(planId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductName());
        hashCode = 31 * hashCode + Objects.hashCode(planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationArns() ? notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningParameters() ? provisioningParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductPlanDetails)) {
            return false;
        }
        ProvisionedProductPlanDetails other = (ProvisionedProductPlanDetails) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(pathId(), other.pathId())
                && Objects.equals(productId(), other.productId()) && Objects.equals(planName(), other.planName())
                && Objects.equals(planId(), other.planId()) && Objects.equals(provisionProductId(), other.provisionProductId())
                && Objects.equals(provisionProductName(), other.provisionProductName())
                && Objects.equals(planTypeAsString(), other.planTypeAsString())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedTime(), other.updatedTime())
                && hasNotificationArns() == other.hasNotificationArns()
                && Objects.equals(notificationArns(), other.notificationArns())
                && hasProvisioningParameters() == other.hasProvisioningParameters()
                && Objects.equals(provisioningParameters(), other.provisioningParameters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedProductPlanDetails").add("CreatedTime", createdTime()).add("PathId", pathId())
                .add("ProductId", productId()).add("PlanName", planName()).add("PlanId", planId())
                .add("ProvisionProductId", provisionProductId()).add("ProvisionProductName", provisionProductName())
                .add("PlanType", planTypeAsString()).add("ProvisioningArtifactId", provisioningArtifactId())
                .add("Status", statusAsString()).add("UpdatedTime", updatedTime())
                .add("NotificationArns", hasNotificationArns() ? notificationArns() : null)
                .add("ProvisioningParameters", hasProvisioningParameters() ? provisioningParameters() : null)
                .add("Tags", hasTags() ? tags() : null).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "PlanName":
            return Optional.ofNullable(clazz.cast(planName()));
        case "PlanId":
            return Optional.ofNullable(clazz.cast(planId()));
        case "ProvisionProductId":
            return Optional.ofNullable(clazz.cast(provisionProductId()));
        case "ProvisionProductName":
            return Optional.ofNullable(clazz.cast(provisionProductName()));
        case "PlanType":
            return Optional.ofNullable(clazz.cast(planTypeAsString()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        case "NotificationArns":
            return Optional.ofNullable(clazz.cast(notificationArns()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductPlanDetails, T> g) {
        return obj -> g.apply((ProvisionedProductPlanDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedProductPlanDetails> {
        /**
         * <p>
         * The UTC time stamp of the creation time.
         * </p>
         * 
         * @param createdTime
         *        The UTC time stamp of the creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The path identifier of the product. This value is optional if the product has a default path, and required if
         * the product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>.
         * </p>
         * 
         * @param pathId
         *        The path identifier of the product. This value is optional if the product has a default path, and
         *        required if the product has more than one path. To list the paths for a product, use
         *        <a>ListLaunchPaths</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param productId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The name of the plan.
         * </p>
         * 
         * @param planName
         *        The name of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planName(String planName);

        /**
         * <p>
         * The plan identifier.
         * </p>
         * 
         * @param planId
         *        The plan identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planId(String planId);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param provisionProductId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductId(String provisionProductId);

        /**
         * <p>
         * The user-friendly name of the provisioned product.
         * </p>
         * 
         * @param provisionProductName
         *        The user-friendly name of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductName(String provisionProductName);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see ProvisionedProductPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanType
         */
        Builder planType(String planType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see ProvisionedProductPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanType
         */
        Builder planType(ProvisionedProductPlanType planType);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see ProvisionedProductPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see ProvisionedProductPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanStatus
         */
        Builder status(ProvisionedProductPlanStatus status);

        /**
         * <p>
         * The time when the plan was last updated.
         * </p>
         * 
         * @param updatedTime
         *        The time when the plan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(Instant updatedTime);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(Collection<String> notificationArns);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(String... notificationArns);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(UpdateProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisioningParameters(List<UpdateProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(java.util.Collection<UpdateProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder>... provisioningParameters);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.servicecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdTime;

        private String pathId;

        private String productId;

        private String planName;

        private String planId;

        private String provisionProductId;

        private String provisionProductName;

        private String planType;

        private String provisioningArtifactId;

        private String status;

        private Instant updatedTime;

        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();

        private List<UpdateProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductPlanDetails model) {
            createdTime(model.createdTime);
            pathId(model.pathId);
            productId(model.productId);
            planName(model.planName);
            planId(model.planId);
            provisionProductId(model.provisionProductId);
            provisionProductName(model.provisionProductName);
            planType(model.planType);
            provisioningArtifactId(model.provisioningArtifactId);
            status(model.status);
            updatedTime(model.updatedTime);
            notificationArns(model.notificationArns);
            provisioningParameters(model.provisioningParameters);
            tags(model.tags);
            statusMessage(model.statusMessage);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getPathId() {
            return pathId;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getPlanName() {
            return planName;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final String getPlanId() {
            return planId;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final String getProvisionProductId() {
            return provisionProductId;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final String getProvisionProductName() {
            return provisionProductName;
        }

        public final void setProvisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
        }

        @Override
        public final Builder provisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
            return this;
        }

        public final String getPlanType() {
            return planType;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(ProvisionedProductPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedProductPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedTime() {
            return updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final Collection<String> getNotificationArns() {
            if (notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationArns;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String... notificationArns) {
            notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final List<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            List<UpdateProvisioningParameter.Builder> result = UpdateProvisioningParametersCopier
                    .copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> UpdateProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ProvisionedProductPlanDetails build() {
            return new ProvisionedProductPlanDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
