/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectPortfolioShareRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<RejectPortfolioShareRequest.Builder, RejectPortfolioShareRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(RejectPortfolioShareRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(RejectPortfolioShareRequest::portfolioId))
            .setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> PORTFOLIO_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioShareType").getter(getter(RejectPortfolioShareRequest::portfolioShareTypeAsString))
            .setter(setter(Builder::portfolioShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, PORTFOLIO_SHARE_TYPE_FIELD));

    private final String acceptLanguage;

    private final String portfolioId;

    private final String portfolioShareType;

    private RejectPortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.portfolioShareType = builder.portfolioShareType;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The type of shared portfolios to reject. The default is to reject imported portfolios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORTED</code> - Reject imported portfolios.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example,
     * <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #portfolioShareType} will return {@link PortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #portfolioShareTypeAsString}.
     * </p>
     * 
     * @return The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPORTED</code> - Reject imported portfolios.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example,
     *         <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
     * @see PortfolioShareType
     */
    public final PortfolioShareType portfolioShareType() {
        return PortfolioShareType.fromValue(portfolioShareType);
    }

    /**
     * <p>
     * The type of shared portfolios to reject. The default is to reject imported portfolios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORTED</code> - Reject imported portfolios.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example,
     * <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #portfolioShareType} will return {@link PortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #portfolioShareTypeAsString}.
     * </p>
     * 
     * @return The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPORTED</code> - Reject imported portfolios.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example,
     *         <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
     * @see PortfolioShareType
     */
    public final String portfolioShareTypeAsString() {
        return portfolioShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectPortfolioShareRequest)) {
            return false;
        }
        RejectPortfolioShareRequest other = (RejectPortfolioShareRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(portfolioShareTypeAsString(), other.portfolioShareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectPortfolioShareRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("PortfolioShareType", portfolioShareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "PortfolioShareType":
            return Optional.ofNullable(clazz.cast(portfolioShareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectPortfolioShareRequest, T> g) {
        return obj -> g.apply((RejectPortfolioShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RejectPortfolioShareRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The type of shared portfolios to reject. The default is to reject imported portfolios.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPORTED</code> - Reject imported portfolios.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example,
         * <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
         * </p>
         * 
         * @param portfolioShareType
         *        The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your
         *        organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPORTED</code> - Reject imported portfolios.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example,
         *        <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
         * @see PortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortfolioShareType
         */
        Builder portfolioShareType(String portfolioShareType);

        /**
         * <p>
         * The type of shared portfolios to reject. The default is to reject imported portfolios.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPORTED</code> - Reject imported portfolios.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example,
         * <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
         * </p>
         * 
         * @param portfolioShareType
         *        The type of shared portfolios to reject. The default is to reject imported portfolios.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_ORGANIZATIONS</code> - Reject portfolios shared by the management account of your
         *        organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPORTED</code> - Reject imported portfolios.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICECATALOG</code> - Not supported. (Throws ResourceNotFoundException.)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example,
         *        <code>aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS</code>
         * @see PortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortfolioShareType
         */
        Builder portfolioShareType(PortfolioShareType portfolioShareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String portfolioShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectPortfolioShareRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            portfolioShareType(model.portfolioShareType);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getPortfolioShareType() {
            return portfolioShareType;
        }

        public final void setPortfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
        }

        @Override
        public final Builder portfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
            return this;
        }

        @Override
        public final Builder portfolioShareType(PortfolioShareType portfolioShareType) {
            this.portfolioShareType(portfolioShareType == null ? null : portfolioShareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectPortfolioShareRequest build() {
            return new RejectPortfolioShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
