/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttributeGroupsResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<ListAttributeGroupsResponse.Builder, ListAttributeGroupsResponse> {
    private static final SdkField<List<AttributeGroupSummary>> ATTRIBUTE_GROUPS_FIELD = SdkField
            .<List<AttributeGroupSummary>> builder(MarshallingType.LIST)
            .memberName("attributeGroups")
            .getter(getter(ListAttributeGroupsResponse::attributeGroups))
            .setter(setter(Builder::attributeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAttributeGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AttributeGroupSummary> attributeGroups;

    private final String nextToken;

    private ListAttributeGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.attributeGroups = builder.attributeGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeGroups() {
        return attributeGroups != null && !(attributeGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This list of attribute groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeGroups} method.
     * </p>
     * 
     * @return This list of attribute groups.
     */
    public final List<AttributeGroupSummary> attributeGroups() {
        return attributeGroups;
    }

    /**
     * <p>
     * The token to use to get the next page of results after a previous API call.
     * </p>
     * 
     * @return The token to use to get the next page of results after a previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeGroups() ? attributeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttributeGroupsResponse)) {
            return false;
        }
        ListAttributeGroupsResponse other = (ListAttributeGroupsResponse) obj;
        return hasAttributeGroups() == other.hasAttributeGroups() && Objects.equals(attributeGroups(), other.attributeGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttributeGroupsResponse")
                .add("AttributeGroups", hasAttributeGroups() ? attributeGroups() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeGroups":
            return Optional.ofNullable(clazz.cast(attributeGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttributeGroupsResponse, T> g) {
        return obj -> g.apply((ListAttributeGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAttributeGroupsResponse> {
        /**
         * <p>
         * This list of attribute groups.
         * </p>
         * 
         * @param attributeGroups
         *        This list of attribute groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroups(Collection<AttributeGroupSummary> attributeGroups);

        /**
         * <p>
         * This list of attribute groups.
         * </p>
         * 
         * @param attributeGroups
         *        This list of attribute groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroups(AttributeGroupSummary... attributeGroups);

        /**
         * <p>
         * This list of attribute groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #attributeGroups(List<AttributeGroupSummary>)}.
         * 
         * @param attributeGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeGroups(java.util.Collection<AttributeGroupSummary>)
         */
        Builder attributeGroups(Consumer<AttributeGroupSummary.Builder>... attributeGroups);

        /**
         * <p>
         * The token to use to get the next page of results after a previous API call.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results after a previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private List<AttributeGroupSummary> attributeGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttributeGroupsResponse model) {
            super(model);
            attributeGroups(model.attributeGroups);
            nextToken(model.nextToken);
        }

        public final List<AttributeGroupSummary.Builder> getAttributeGroups() {
            List<AttributeGroupSummary.Builder> result = AttributeGroupSummariesCopier.copyToBuilder(this.attributeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeGroups(Collection<AttributeGroupSummary.BuilderImpl> attributeGroups) {
            this.attributeGroups = AttributeGroupSummariesCopier.copyFromBuilder(attributeGroups);
        }

        @Override
        public final Builder attributeGroups(Collection<AttributeGroupSummary> attributeGroups) {
            this.attributeGroups = AttributeGroupSummariesCopier.copy(attributeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeGroups(AttributeGroupSummary... attributeGroups) {
            attributeGroups(Arrays.asList(attributeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeGroups(Consumer<AttributeGroupSummary.Builder>... attributeGroups) {
            attributeGroups(Stream.of(attributeGroups).map(c -> AttributeGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttributeGroupsResponse build() {
            return new ListAttributeGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
