/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents your Amazon SES daily sending quota, maximum send rate, and the number of emails you have sent in the last
 * 24 hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSendQuotaResponse extends SesResponse implements
        ToCopyableBuilder<GetSendQuotaResponse.Builder, GetSendQuotaResponse> {
    private static final SdkField<Double> MAX24_HOUR_SEND_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Max24HourSend").getter(getter(GetSendQuotaResponse::max24HourSend))
            .setter(setter(Builder::max24HourSend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max24HourSend").build()).build();

    private static final SdkField<Double> MAX_SEND_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxSendRate").getter(getter(GetSendQuotaResponse::maxSendRate)).setter(setter(Builder::maxSendRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSendRate").build()).build();

    private static final SdkField<Double> SENT_LAST24_HOURS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SentLast24Hours").getter(getter(GetSendQuotaResponse::sentLast24Hours))
            .setter(setter(Builder::sentLast24Hours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentLast24Hours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX24_HOUR_SEND_FIELD,
            MAX_SEND_RATE_FIELD, SENT_LAST24_HOURS_FIELD));

    private final Double max24HourSend;

    private final Double maxSendRate;

    private final Double sentLast24Hours;

    private GetSendQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.max24HourSend = builder.max24HourSend;
        this.maxSendRate = builder.maxSendRate;
        this.sentLast24Hours = builder.sentLast24Hours;
    }

    /**
     * <p>
     * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an
     * unlimited quota.
     * </p>
     * 
     * @return The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies
     *         an unlimited quota.
     */
    public final Double max24HourSend() {
        return max24HourSend;
    }

    /**
     * <p>
     * The maximum number of emails that Amazon SES can accept from the user's account per second.
     * </p>
     * <note>
     * <p>
     * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
     * </p>
     * </note>
     * 
     * @return The maximum number of emails that Amazon SES can accept from the user's account per second.</p> <note>
     *         <p>
     *         The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
     *         </p>
     */
    public final Double maxSendRate() {
        return maxSendRate;
    }

    /**
     * <p>
     * The number of emails sent during the previous 24 hours.
     * </p>
     * 
     * @return The number of emails sent during the previous 24 hours.
     */
    public final Double sentLast24Hours() {
        return sentLast24Hours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(max24HourSend());
        hashCode = 31 * hashCode + Objects.hashCode(maxSendRate());
        hashCode = 31 * hashCode + Objects.hashCode(sentLast24Hours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendQuotaResponse)) {
            return false;
        }
        GetSendQuotaResponse other = (GetSendQuotaResponse) obj;
        return Objects.equals(max24HourSend(), other.max24HourSend()) && Objects.equals(maxSendRate(), other.maxSendRate())
                && Objects.equals(sentLast24Hours(), other.sentLast24Hours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSendQuotaResponse").add("Max24HourSend", max24HourSend()).add("MaxSendRate", maxSendRate())
                .add("SentLast24Hours", sentLast24Hours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Max24HourSend":
            return Optional.ofNullable(clazz.cast(max24HourSend()));
        case "MaxSendRate":
            return Optional.ofNullable(clazz.cast(maxSendRate()));
        case "SentLast24Hours":
            return Optional.ofNullable(clazz.cast(sentLast24Hours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSendQuotaResponse, T> g) {
        return obj -> g.apply((GetSendQuotaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSendQuotaResponse> {
        /**
         * <p>
         * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an
         * unlimited quota.
         * </p>
         * 
         * @param max24HourSend
         *        The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1
         *        signifies an unlimited quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max24HourSend(Double max24HourSend);

        /**
         * <p>
         * The maximum number of emails that Amazon SES can accept from the user's account per second.
         * </p>
         * <note>
         * <p>
         * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
         * </p>
         * </note>
         * 
         * @param maxSendRate
         *        The maximum number of emails that Amazon SES can accept from the user's account per second.</p> <note>
         *        <p>
         *        The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSendRate(Double maxSendRate);

        /**
         * <p>
         * The number of emails sent during the previous 24 hours.
         * </p>
         * 
         * @param sentLast24Hours
         *        The number of emails sent during the previous 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentLast24Hours(Double sentLast24Hours);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Double max24HourSend;

        private Double maxSendRate;

        private Double sentLast24Hours;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendQuotaResponse model) {
            super(model);
            max24HourSend(model.max24HourSend);
            maxSendRate(model.maxSendRate);
            sentLast24Hours(model.sentLast24Hours);
        }

        public final Double getMax24HourSend() {
            return max24HourSend;
        }

        public final void setMax24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
        }

        @Override
        public final Builder max24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
            return this;
        }

        public final Double getMaxSendRate() {
            return maxSendRate;
        }

        public final void setMaxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
        }

        @Override
        public final Builder maxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
            return this;
        }

        public final Double getSentLast24Hours() {
            return sentLast24Hours;
        }

        public final void setSentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
        }

        @Override
        public final Builder sentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
            return this;
        }

        @Override
        public GetSendQuotaResponse build() {
            return new GetSendQuotaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
