/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connector implements SdkPojo, Serializable, ToCopyableBuilder<Connector.Builder, Connector> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorId").getter(getter(Connector::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorId").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Connector::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Connector::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> CAPABILITY_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilityList")
            .getter(getter(Connector::capabilityListAsStrings))
            .setter(setter(Builder::capabilityListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VM_MANAGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerName").getter(getter(Connector::vmManagerName)).setter(setter(Builder::vmManagerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerName").build()).build();

    private static final SdkField<String> VM_MANAGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerType").getter(getter(Connector::vmManagerTypeAsString)).setter(setter(Builder::vmManagerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerType").build()).build();

    private static final SdkField<String> VM_MANAGER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerId").getter(getter(Connector::vmManagerId)).setter(setter(Builder::vmManagerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerId").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(Connector::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("macAddress").getter(getter(Connector::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final SdkField<Instant> ASSOCIATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("associatedOn").getter(getter(Connector::associatedOn)).setter(setter(Builder::associatedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            VERSION_FIELD, STATUS_FIELD, CAPABILITY_LIST_FIELD, VM_MANAGER_NAME_FIELD, VM_MANAGER_TYPE_FIELD,
            VM_MANAGER_ID_FIELD, IP_ADDRESS_FIELD, MAC_ADDRESS_FIELD, ASSOCIATED_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorId;

    private final String version;

    private final String status;

    private final List<String> capabilityList;

    private final String vmManagerName;

    private final String vmManagerType;

    private final String vmManagerId;

    private final String ipAddress;

    private final String macAddress;

    private final Instant associatedOn;

    private Connector(BuilderImpl builder) {
        this.connectorId = builder.connectorId;
        this.version = builder.version;
        this.status = builder.status;
        this.capabilityList = builder.capabilityList;
        this.vmManagerName = builder.vmManagerName;
        this.vmManagerType = builder.vmManagerType;
        this.vmManagerId = builder.vmManagerId;
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
        this.associatedOn = builder.associatedOn;
    }

    /**
     * <p>
     * The ID of the connector.
     * </p>
     * 
     * @return The ID of the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The connector version.
     * </p>
     * 
     * @return The connector version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The status of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connector.
     * @see ConnectorStatus
     */
    public final ConnectorStatus status() {
        return ConnectorStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connector.
     * @see ConnectorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The capabilities of the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilityList} method.
     * </p>
     * 
     * @return The capabilities of the connector.
     */
    public final List<ConnectorCapability> capabilityList() {
        return ConnectorCapabilityListCopier.copyStringToEnum(capabilityList);
    }

    /**
     * For responses, this returns true if the service returned a value for the CapabilityList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilityList() {
        return capabilityList != null && !(capabilityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities of the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilityList} method.
     * </p>
     * 
     * @return The capabilities of the connector.
     */
    public final List<String> capabilityListAsStrings() {
        return capabilityList;
    }

    /**
     * <p>
     * The name of the VM manager.
     * </p>
     * 
     * @return The name of the VM manager.
     */
    public final String vmManagerName() {
        return vmManagerName;
    }

    /**
     * <p>
     * The VM management product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vmManagerType}
     * will return {@link VmManagerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vmManagerTypeAsString}.
     * </p>
     * 
     * @return The VM management product.
     * @see VmManagerType
     */
    public final VmManagerType vmManagerType() {
        return VmManagerType.fromValue(vmManagerType);
    }

    /**
     * <p>
     * The VM management product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vmManagerType}
     * will return {@link VmManagerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vmManagerTypeAsString}.
     * </p>
     * 
     * @return The VM management product.
     * @see VmManagerType
     */
    public final String vmManagerTypeAsString() {
        return vmManagerType;
    }

    /**
     * <p>
     * The ID of the VM manager.
     * </p>
     * 
     * @return The ID of the VM manager.
     */
    public final String vmManagerId() {
        return vmManagerId;
    }

    /**
     * <p>
     * The IP address of the connector.
     * </p>
     * 
     * @return The IP address of the connector.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The MAC address of the connector.
     * </p>
     * 
     * @return The MAC address of the connector.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The time the connector was associated.
     * </p>
     * 
     * @return The time the connector was associated.
     */
    public final Instant associatedOn() {
        return associatedOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilityList() ? capabilityListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerName());
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(associatedOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(version(), other.version())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasCapabilityList() == other.hasCapabilityList()
                && Objects.equals(capabilityListAsStrings(), other.capabilityListAsStrings())
                && Objects.equals(vmManagerName(), other.vmManagerName())
                && Objects.equals(vmManagerTypeAsString(), other.vmManagerTypeAsString())
                && Objects.equals(vmManagerId(), other.vmManagerId()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(macAddress(), other.macAddress()) && Objects.equals(associatedOn(), other.associatedOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Connector").add("ConnectorId", connectorId()).add("Version", version())
                .add("Status", statusAsString()).add("CapabilityList", hasCapabilityList() ? capabilityListAsStrings() : null)
                .add("VmManagerName", vmManagerName()).add("VmManagerType", vmManagerTypeAsString())
                .add("VmManagerId", vmManagerId()).add("IpAddress", ipAddress()).add("MacAddress", macAddress())
                .add("AssociatedOn", associatedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "capabilityList":
            return Optional.ofNullable(clazz.cast(capabilityListAsStrings()));
        case "vmManagerName":
            return Optional.ofNullable(clazz.cast(vmManagerName()));
        case "vmManagerType":
            return Optional.ofNullable(clazz.cast(vmManagerTypeAsString()));
        case "vmManagerId":
            return Optional.ofNullable(clazz.cast(vmManagerId()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "macAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "associatedOn":
            return Optional.ofNullable(clazz.cast(associatedOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connector, T> g) {
        return obj -> g.apply((Connector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connector> {
        /**
         * <p>
         * The ID of the connector.
         * </p>
         * 
         * @param connectorId
         *        The ID of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The connector version.
         * </p>
         * 
         * @param version
         *        The connector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The status of the connector.
         * </p>
         * 
         * @param status
         *        The status of the connector.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the connector.
         * </p>
         * 
         * @param status
         *        The status of the connector.
         * @see ConnectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorStatus
         */
        Builder status(ConnectorStatus status);

        /**
         * <p>
         * The capabilities of the connector.
         * </p>
         * 
         * @param capabilityList
         *        The capabilities of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityListWithStrings(Collection<String> capabilityList);

        /**
         * <p>
         * The capabilities of the connector.
         * </p>
         * 
         * @param capabilityList
         *        The capabilities of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityListWithStrings(String... capabilityList);

        /**
         * <p>
         * The capabilities of the connector.
         * </p>
         * 
         * @param capabilityList
         *        The capabilities of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityList(Collection<ConnectorCapability> capabilityList);

        /**
         * <p>
         * The capabilities of the connector.
         * </p>
         * 
         * @param capabilityList
         *        The capabilities of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityList(ConnectorCapability... capabilityList);

        /**
         * <p>
         * The name of the VM manager.
         * </p>
         * 
         * @param vmManagerName
         *        The name of the VM manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmManagerName(String vmManagerName);

        /**
         * <p>
         * The VM management product.
         * </p>
         * 
         * @param vmManagerType
         *        The VM management product.
         * @see VmManagerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VmManagerType
         */
        Builder vmManagerType(String vmManagerType);

        /**
         * <p>
         * The VM management product.
         * </p>
         * 
         * @param vmManagerType
         *        The VM management product.
         * @see VmManagerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VmManagerType
         */
        Builder vmManagerType(VmManagerType vmManagerType);

        /**
         * <p>
         * The ID of the VM manager.
         * </p>
         * 
         * @param vmManagerId
         *        The ID of the VM manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmManagerId(String vmManagerId);

        /**
         * <p>
         * The IP address of the connector.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The MAC address of the connector.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The time the connector was associated.
         * </p>
         * 
         * @param associatedOn
         *        The time the connector was associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedOn(Instant associatedOn);
    }

    static final class BuilderImpl implements Builder {
        private String connectorId;

        private String version;

        private String status;

        private List<String> capabilityList = DefaultSdkAutoConstructList.getInstance();

        private String vmManagerName;

        private String vmManagerType;

        private String vmManagerId;

        private String ipAddress;

        private String macAddress;

        private Instant associatedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(Connector model) {
            connectorId(model.connectorId);
            version(model.version);
            status(model.status);
            capabilityListWithStrings(model.capabilityList);
            vmManagerName(model.vmManagerName);
            vmManagerType(model.vmManagerType);
            vmManagerId(model.vmManagerId);
            ipAddress(model.ipAddress);
            macAddress(model.macAddress);
            associatedOn(model.associatedOn);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getCapabilityList() {
            if (capabilityList instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilityList;
        }

        public final void setCapabilityList(Collection<String> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copy(capabilityList);
        }

        @Override
        public final Builder capabilityListWithStrings(Collection<String> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copy(capabilityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilityListWithStrings(String... capabilityList) {
            capabilityListWithStrings(Arrays.asList(capabilityList));
            return this;
        }

        @Override
        public final Builder capabilityList(Collection<ConnectorCapability> capabilityList) {
            this.capabilityList = ConnectorCapabilityListCopier.copyEnumToString(capabilityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilityList(ConnectorCapability... capabilityList) {
            capabilityList(Arrays.asList(capabilityList));
            return this;
        }

        public final String getVmManagerName() {
            return vmManagerName;
        }

        public final void setVmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
        }

        @Override
        public final Builder vmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
            return this;
        }

        public final String getVmManagerType() {
            return vmManagerType;
        }

        public final void setVmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
        }

        @Override
        public final Builder vmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
            return this;
        }

        @Override
        public final Builder vmManagerType(VmManagerType vmManagerType) {
            this.vmManagerType(vmManagerType == null ? null : vmManagerType.toString());
            return this;
        }

        public final String getVmManagerId() {
            return vmManagerId;
        }

        public final void setVmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
        }

        @Override
        public final Builder vmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final Instant getAssociatedOn() {
            return associatedOn;
        }

        public final void setAssociatedOn(Instant associatedOn) {
            this.associatedOn = associatedOn;
        }

        @Override
        public final Builder associatedOn(Instant associatedOn) {
            this.associatedOn = associatedOn;
            return this;
        }

        @Override
        public Connector build() {
            return new Connector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
