/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about the physical network interface for the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalNetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalNetworkInterface.Builder, PhysicalNetworkInterface> {
    private static final SdkField<String> DEFAULT_GATEWAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultGateway").getter(getter(PhysicalNetworkInterface::defaultGateway))
            .setter(setter(Builder::defaultGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultGateway").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(PhysicalNetworkInterface::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> IP_ADDRESS_ASSIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressAssignment").getter(getter(PhysicalNetworkInterface::ipAddressAssignmentAsString))
            .setter(setter(Builder::ipAddressAssignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressAssignment").build())
            .build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("macAddress").getter(getter(PhysicalNetworkInterface::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final SdkField<String> NETMASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("netmask")
            .getter(getter(PhysicalNetworkInterface::netmask)).setter(setter(Builder::netmask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("netmask").build()).build();

    private static final SdkField<String> PHYSICAL_CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("physicalConnectorType").getter(getter(PhysicalNetworkInterface::physicalConnectorTypeAsString))
            .setter(setter(Builder::physicalConnectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectorType").build())
            .build();

    private static final SdkField<String> PHYSICAL_NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("physicalNetworkInterfaceId")
            .getter(getter(PhysicalNetworkInterface::physicalNetworkInterfaceId))
            .setter(setter(Builder::physicalNetworkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalNetworkInterfaceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_GATEWAY_FIELD,
            IP_ADDRESS_FIELD, IP_ADDRESS_ASSIGNMENT_FIELD, MAC_ADDRESS_FIELD, NETMASK_FIELD, PHYSICAL_CONNECTOR_TYPE_FIELD,
            PHYSICAL_NETWORK_INTERFACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultGateway;

    private final String ipAddress;

    private final String ipAddressAssignment;

    private final String macAddress;

    private final String netmask;

    private final String physicalConnectorType;

    private final String physicalNetworkInterfaceId;

    private PhysicalNetworkInterface(BuilderImpl builder) {
        this.defaultGateway = builder.defaultGateway;
        this.ipAddress = builder.ipAddress;
        this.ipAddressAssignment = builder.ipAddressAssignment;
        this.macAddress = builder.macAddress;
        this.netmask = builder.netmask;
        this.physicalConnectorType = builder.physicalConnectorType;
        this.physicalNetworkInterfaceId = builder.physicalNetworkInterfaceId;
    }

    /**
     * <p>
     * The default gateway of the device.
     * </p>
     * 
     * @return The default gateway of the device.
     */
    public final String defaultGateway() {
        return defaultGateway;
    }

    /**
     * <p>
     * The IP address of the device.
     * </p>
     * 
     * @return The IP address of the device.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * A value that describes whether the IP address is dynamic or persistent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ipAddressAssignment} will return {@link IpAddressAssignment#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ipAddressAssignmentAsString}.
     * </p>
     * 
     * @return A value that describes whether the IP address is dynamic or persistent.
     * @see IpAddressAssignment
     */
    public final IpAddressAssignment ipAddressAssignment() {
        return IpAddressAssignment.fromValue(ipAddressAssignment);
    }

    /**
     * <p>
     * A value that describes whether the IP address is dynamic or persistent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ipAddressAssignment} will return {@link IpAddressAssignment#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ipAddressAssignmentAsString}.
     * </p>
     * 
     * @return A value that describes whether the IP address is dynamic or persistent.
     * @see IpAddressAssignment
     */
    public final String ipAddressAssignmentAsString() {
        return ipAddressAssignment;
    }

    /**
     * <p>
     * The MAC address of the device.
     * </p>
     * 
     * @return The MAC address of the device.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The netmask used to divide the IP address into subnets.
     * </p>
     * 
     * @return The netmask used to divide the IP address into subnets.
     */
    public final String netmask() {
        return netmask;
    }

    /**
     * <p>
     * The physical connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #physicalConnectorType} will return {@link PhysicalConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #physicalConnectorTypeAsString}.
     * </p>
     * 
     * @return The physical connector type.
     * @see PhysicalConnectorType
     */
    public final PhysicalConnectorType physicalConnectorType() {
        return PhysicalConnectorType.fromValue(physicalConnectorType);
    }

    /**
     * <p>
     * The physical connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #physicalConnectorType} will return {@link PhysicalConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #physicalConnectorTypeAsString}.
     * </p>
     * 
     * @return The physical connector type.
     * @see PhysicalConnectorType
     */
    public final String physicalConnectorTypeAsString() {
        return physicalConnectorType;
    }

    /**
     * <p>
     * The physical network interface ID.
     * </p>
     * 
     * @return The physical network interface ID.
     */
    public final String physicalNetworkInterfaceId() {
        return physicalNetworkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultGateway());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressAssignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(netmask());
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(physicalNetworkInterfaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalNetworkInterface)) {
            return false;
        }
        PhysicalNetworkInterface other = (PhysicalNetworkInterface) obj;
        return Objects.equals(defaultGateway(), other.defaultGateway()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(ipAddressAssignmentAsString(), other.ipAddressAssignmentAsString())
                && Objects.equals(macAddress(), other.macAddress()) && Objects.equals(netmask(), other.netmask())
                && Objects.equals(physicalConnectorTypeAsString(), other.physicalConnectorTypeAsString())
                && Objects.equals(physicalNetworkInterfaceId(), other.physicalNetworkInterfaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalNetworkInterface").add("DefaultGateway", defaultGateway()).add("IpAddress", ipAddress())
                .add("IpAddressAssignment", ipAddressAssignmentAsString()).add("MacAddress", macAddress())
                .add("Netmask", netmask()).add("PhysicalConnectorType", physicalConnectorTypeAsString())
                .add("PhysicalNetworkInterfaceId", physicalNetworkInterfaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultGateway":
            return Optional.ofNullable(clazz.cast(defaultGateway()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ipAddressAssignment":
            return Optional.ofNullable(clazz.cast(ipAddressAssignmentAsString()));
        case "macAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "netmask":
            return Optional.ofNullable(clazz.cast(netmask()));
        case "physicalConnectorType":
            return Optional.ofNullable(clazz.cast(physicalConnectorTypeAsString()));
        case "physicalNetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(physicalNetworkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhysicalNetworkInterface, T> g) {
        return obj -> g.apply((PhysicalNetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalNetworkInterface> {
        /**
         * <p>
         * The default gateway of the device.
         * </p>
         * 
         * @param defaultGateway
         *        The default gateway of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultGateway(String defaultGateway);

        /**
         * <p>
         * The IP address of the device.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * A value that describes whether the IP address is dynamic or persistent.
         * </p>
         * 
         * @param ipAddressAssignment
         *        A value that describes whether the IP address is dynamic or persistent.
         * @see IpAddressAssignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressAssignment
         */
        Builder ipAddressAssignment(String ipAddressAssignment);

        /**
         * <p>
         * A value that describes whether the IP address is dynamic or persistent.
         * </p>
         * 
         * @param ipAddressAssignment
         *        A value that describes whether the IP address is dynamic or persistent.
         * @see IpAddressAssignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressAssignment
         */
        Builder ipAddressAssignment(IpAddressAssignment ipAddressAssignment);

        /**
         * <p>
         * The MAC address of the device.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The netmask used to divide the IP address into subnets.
         * </p>
         * 
         * @param netmask
         *        The netmask used to divide the IP address into subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netmask(String netmask);

        /**
         * <p>
         * The physical connector type.
         * </p>
         * 
         * @param physicalConnectorType
         *        The physical connector type.
         * @see PhysicalConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhysicalConnectorType
         */
        Builder physicalConnectorType(String physicalConnectorType);

        /**
         * <p>
         * The physical connector type.
         * </p>
         * 
         * @param physicalConnectorType
         *        The physical connector type.
         * @see PhysicalConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhysicalConnectorType
         */
        Builder physicalConnectorType(PhysicalConnectorType physicalConnectorType);

        /**
         * <p>
         * The physical network interface ID.
         * </p>
         * 
         * @param physicalNetworkInterfaceId
         *        The physical network interface ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalNetworkInterfaceId(String physicalNetworkInterfaceId);
    }

    static final class BuilderImpl implements Builder {
        private String defaultGateway;

        private String ipAddress;

        private String ipAddressAssignment;

        private String macAddress;

        private String netmask;

        private String physicalConnectorType;

        private String physicalNetworkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalNetworkInterface model) {
            defaultGateway(model.defaultGateway);
            ipAddress(model.ipAddress);
            ipAddressAssignment(model.ipAddressAssignment);
            macAddress(model.macAddress);
            netmask(model.netmask);
            physicalConnectorType(model.physicalConnectorType);
            physicalNetworkInterfaceId(model.physicalNetworkInterfaceId);
        }

        public final String getDefaultGateway() {
            return defaultGateway;
        }

        public final void setDefaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
        }

        @Override
        public final Builder defaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getIpAddressAssignment() {
            return ipAddressAssignment;
        }

        public final void setIpAddressAssignment(String ipAddressAssignment) {
            this.ipAddressAssignment = ipAddressAssignment;
        }

        @Override
        public final Builder ipAddressAssignment(String ipAddressAssignment) {
            this.ipAddressAssignment = ipAddressAssignment;
            return this;
        }

        @Override
        public final Builder ipAddressAssignment(IpAddressAssignment ipAddressAssignment) {
            this.ipAddressAssignment(ipAddressAssignment == null ? null : ipAddressAssignment.toString());
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetmask() {
            return netmask;
        }

        public final void setNetmask(String netmask) {
            this.netmask = netmask;
        }

        @Override
        public final Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public final String getPhysicalConnectorType() {
            return physicalConnectorType;
        }

        public final void setPhysicalConnectorType(String physicalConnectorType) {
            this.physicalConnectorType = physicalConnectorType;
        }

        @Override
        public final Builder physicalConnectorType(String physicalConnectorType) {
            this.physicalConnectorType = physicalConnectorType;
            return this;
        }

        @Override
        public final Builder physicalConnectorType(PhysicalConnectorType physicalConnectorType) {
            this.physicalConnectorType(physicalConnectorType == null ? null : physicalConnectorType.toString());
            return this;
        }

        public final String getPhysicalNetworkInterfaceId() {
            return physicalNetworkInterfaceId;
        }

        public final void setPhysicalNetworkInterfaceId(String physicalNetworkInterfaceId) {
            this.physicalNetworkInterfaceId = physicalNetworkInterfaceId;
        }

        @Override
        public final Builder physicalNetworkInterfaceId(String physicalNetworkInterfaceId) {
            this.physicalNetworkInterfaceId = physicalNetworkInterfaceId;
            return this;
        }

        @Override
        public PhysicalNetworkInterface build() {
            return new PhysicalNetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
