/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ShiftCoveragesMapCopier {
    static Map<String, List<CoverageTime>> copy(Map<String, ? extends Collection<? extends CoverageTime>> shiftCoveragesMapParam) {
        Map<String, List<CoverageTime>> map;
        if (shiftCoveragesMapParam == null || shiftCoveragesMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<CoverageTime>> modifiableMap = new LinkedHashMap<>();
            shiftCoveragesMapParam.forEach((key, value) -> {
                List<CoverageTime> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<CoverageTime> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<CoverageTime>> copyFromBuilder(
            Map<String, ? extends Collection<? extends CoverageTime.Builder>> shiftCoveragesMapParam) {
        Map<String, List<CoverageTime>> map;
        if (shiftCoveragesMapParam == null || shiftCoveragesMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<CoverageTime>> modifiableMap = new LinkedHashMap<>();
            shiftCoveragesMapParam.forEach((key, value) -> {
                List<CoverageTime> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<CoverageTime> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        CoverageTime member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<CoverageTime.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends CoverageTime>> shiftCoveragesMapParam) {
        Map<String, List<CoverageTime.Builder>> map;
        if (shiftCoveragesMapParam == null || shiftCoveragesMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<CoverageTime.Builder>> modifiableMap = new LinkedHashMap<>();
            shiftCoveragesMapParam.forEach((key, value) -> {
                List<CoverageTime.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<CoverageTime.Builder> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        CoverageTime.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<CoverageTime>> copyEnumToString(
            Map<DayOfWeek, ? extends Collection<? extends CoverageTime>> shiftCoveragesMapParam) {
        Map<String, List<CoverageTime>> map;
        if (shiftCoveragesMapParam == null || shiftCoveragesMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<CoverageTime>> modifiableMap = new LinkedHashMap<>();
            shiftCoveragesMapParam.forEach((key, value) -> {
                String result = key.toString();
                List<CoverageTime> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<CoverageTime> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(result, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DayOfWeek, List<CoverageTime>> copyStringToEnum(
            Map<String, ? extends Collection<? extends CoverageTime>> shiftCoveragesMapParam) {
        Map<DayOfWeek, List<CoverageTime>> map;
        if (shiftCoveragesMapParam == null || shiftCoveragesMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DayOfWeek, List<CoverageTime>> modifiableMap = new LinkedHashMap<>();
            shiftCoveragesMapParam.forEach((key, value) -> {
                DayOfWeek result = DayOfWeek.fromValue(key);
                List<CoverageTime> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<CoverageTime> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                if (result != DayOfWeek.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, list);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
