/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use the AttributeValueList to filter by string or integer values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValueList implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeValueList.Builder, AttributeValueList> {
    private static final SdkField<List<Integer>> INTEGER_VALUES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("integerValues")
            .getter(getter(AttributeValueList::integerValues))
            .setter(setter(Builder::integerValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stringValues")
            .getter(getter(AttributeValueList::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUES_FIELD,
            STRING_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> integerValues;

    private final List<String> stringValues;

    private final Type type;

    private AttributeValueList(BuilderImpl builder) {
        this.integerValues = builder.integerValues;
        this.stringValues = builder.stringValues;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegerValues() {
        return integerValues != null && !(integerValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of integer values that the filter matches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerValues} method.
     * </p>
     * 
     * @return The list of integer values that the filter matches.
     */
    public final List<Integer> integerValues() {
        return integerValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of string values that the filter matches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return The list of string values that the filter matches.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerValues() ? integerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueList)) {
            return false;
        }
        AttributeValueList other = (AttributeValueList) obj;
        return hasIntegerValues() == other.hasIntegerValues() && Objects.equals(integerValues(), other.integerValues())
                && hasStringValues() == other.hasStringValues() && Objects.equals(stringValues(), other.stringValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeValueList").add("IntegerValues", hasIntegerValues() ? integerValues() : null)
                .add("StringValues", hasStringValues() ? stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerValues":
            return Optional.ofNullable(clazz.cast(integerValues()));
        case "stringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #integerValues()} initialized to the given value.
     *
     * <p>
     * The list of integer values that the filter matches.
     * </p>
     * 
     * @param integerValues
     *        The list of integer values that the filter matches.
     */
    public static AttributeValueList fromIntegerValues(List<Integer> integerValues) {
        return builder().integerValues(integerValues).build();
    }

    /**
     * Create an instance of this class with {@link #stringValues()} initialized to the given value.
     *
     * <p>
     * The list of string values that the filter matches.
     * </p>
     * 
     * @param stringValues
     *        The list of string values that the filter matches.
     */
    public static AttributeValueList fromStringValues(List<String> stringValues) {
        return builder().stringValues(stringValues).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValueList, T> g) {
        return obj -> g.apply((AttributeValueList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValueList> {
        /**
         * <p>
         * The list of integer values that the filter matches.
         * </p>
         * 
         * @param integerValues
         *        The list of integer values that the filter matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValues(Collection<Integer> integerValues);

        /**
         * <p>
         * The list of integer values that the filter matches.
         * </p>
         * 
         * @param integerValues
         *        The list of integer values that the filter matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValues(Integer... integerValues);

        /**
         * <p>
         * The list of string values that the filter matches.
         * </p>
         * 
         * @param stringValues
         *        The list of string values that the filter matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * The list of string values that the filter matches.
         * </p>
         * 
         * @param stringValues
         *        The list of string values that the filter matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> integerValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValueList model) {
            integerValues(model.integerValues);
            stringValues(model.stringValues);
        }

        public final Collection<Integer> getIntegerValues() {
            if (integerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return integerValues;
        }

        public final void setIntegerValues(Collection<Integer> integerValues) {
            Object oldValue = this.integerValues;
            this.integerValues = IntegerListCopier.copy(integerValues);
            handleUnionValueChange(Type.INTEGER_VALUES, oldValue, this.integerValues);
        }

        @Override
        public final Builder integerValues(Collection<Integer> integerValues) {
            Object oldValue = this.integerValues;
            this.integerValues = IntegerListCopier.copy(integerValues);
            handleUnionValueChange(Type.INTEGER_VALUES, oldValue, this.integerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerValues(Integer... integerValues) {
            integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = StringListCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            Object oldValue = this.stringValues;
            this.stringValues = StringListCopier.copy(stringValues);
            handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        @Override
        public AttributeValueList build() {
            return new AttributeValueList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AttributeValueList#type()
     */
    public enum Type {
        INTEGER_VALUES,

        STRING_VALUES,

        UNKNOWN_TO_SDK_VERSION
    }
}
