/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTimelineEventRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<CreateTimelineEventRequest.Builder, CreateTimelineEventRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateTimelineEventRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EVENT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventData").getter(getter(CreateTimelineEventRequest::eventData)).setter(setter(Builder::eventData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()).build();

    private static final SdkField<List<EventReference>> EVENT_REFERENCES_FIELD = SdkField
            .<List<EventReference>> builder(MarshallingType.LIST)
            .memberName("eventReferences")
            .getter(getter(CreateTimelineEventRequest::eventReferences))
            .setter(setter(Builder::eventReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTime").getter(getter(CreateTimelineEventRequest::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(CreateTimelineEventRequest::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentRecordArn").getter(getter(CreateTimelineEventRequest::incidentRecordArn))
            .setter(setter(Builder::incidentRecordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            EVENT_DATA_FIELD, EVENT_REFERENCES_FIELD, EVENT_TIME_FIELD, EVENT_TYPE_FIELD, INCIDENT_RECORD_ARN_FIELD));

    private final String clientToken;

    private final String eventData;

    private final List<EventReference> eventReferences;

    private final Instant eventTime;

    private final String eventType;

    private final String incidentRecordArn;

    private CreateTimelineEventRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.eventData = builder.eventData;
        this.eventReferences = builder.eventReferences;
        this.eventTime = builder.eventTime;
        this.eventType = builder.eventType;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    /**
     * <p>
     * A token ensuring that the action is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the action is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A short description of the event.
     * </p>
     * 
     * @return A short description of the event.
     */
    public final String eventData() {
        return eventData;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventReferences() {
        return eventReferences != null && !(eventReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web Services resource
     * involved in the incident or in some way associated with it. When you specify a reference, you enter the Amazon
     * Resource Name (ARN) of the resource. You can also specify a related item. As an example, you could specify the
     * ARN of an Amazon DynamoDB (DynamoDB) table. The table for this example is the resource. You could also specify a
     * Amazon CloudWatch metric for that table. The metric is the related item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventReferences} method.
     * </p>
     * 
     * @return Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web Services
     *         resource involved in the incident or in some way associated with it. When you specify a reference, you
     *         enter the Amazon Resource Name (ARN) of the resource. You can also specify a related item. As an example,
     *         you could specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for this example is the
     *         resource. You could also specify a Amazon CloudWatch metric for that table. The metric is the related
     *         item.
     */
    public final List<EventReference> eventReferences() {
        return eventReferences;
    }

    /**
     * <p>
     * The time that the event occurred.
     * </p>
     * 
     * @return The time that the event occurred.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The type of the event. You can create timeline events of type <code>Custom Event</code>.
     * </p>
     * 
     * @return The type of the event. You can create timeline events of type <code>Custom Event</code>.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident record to which the event will be added.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident record to which the event will be added.
     */
    public final String incidentRecordArn() {
        return incidentRecordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(eventData());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventReferences() ? eventReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTimelineEventRequest)) {
            return false;
        }
        CreateTimelineEventRequest other = (CreateTimelineEventRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(eventData(), other.eventData())
                && hasEventReferences() == other.hasEventReferences()
                && Objects.equals(eventReferences(), other.eventReferences()) && Objects.equals(eventTime(), other.eventTime())
                && Objects.equals(eventType(), other.eventType())
                && Objects.equals(incidentRecordArn(), other.incidentRecordArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTimelineEventRequest").add("ClientToken", clientToken()).add("EventData", eventData())
                .add("EventReferences", hasEventReferences() ? eventReferences() : null).add("EventTime", eventTime())
                .add("EventType", eventType()).add("IncidentRecordArn", incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "eventData":
            return Optional.ofNullable(clazz.cast(eventData()));
        case "eventReferences":
            return Optional.ofNullable(clazz.cast(eventReferences()));
        case "eventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "incidentRecordArn":
            return Optional.ofNullable(clazz.cast(incidentRecordArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTimelineEventRequest, T> g) {
        return obj -> g.apply((CreateTimelineEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTimelineEventRequest> {
        /**
         * <p>
         * A token ensuring that the action is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token ensuring that the action is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A short description of the event.
         * </p>
         * 
         * @param eventData
         *        A short description of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventData(String eventData);

        /**
         * <p>
         * Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web Services
         * resource involved in the incident or in some way associated with it. When you specify a reference, you enter
         * the Amazon Resource Name (ARN) of the resource. You can also specify a related item. As an example, you could
         * specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for this example is the resource. You could
         * also specify a Amazon CloudWatch metric for that table. The metric is the related item.
         * </p>
         * 
         * @param eventReferences
         *        Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web
         *        Services resource involved in the incident or in some way associated with it. When you specify a
         *        reference, you enter the Amazon Resource Name (ARN) of the resource. You can also specify a related
         *        item. As an example, you could specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for
         *        this example is the resource. You could also specify a Amazon CloudWatch metric for that table. The
         *        metric is the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventReferences(Collection<EventReference> eventReferences);

        /**
         * <p>
         * Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web Services
         * resource involved in the incident or in some way associated with it. When you specify a reference, you enter
         * the Amazon Resource Name (ARN) of the resource. You can also specify a related item. As an example, you could
         * specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for this example is the resource. You could
         * also specify a Amazon CloudWatch metric for that table. The metric is the related item.
         * </p>
         * 
         * @param eventReferences
         *        Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web
         *        Services resource involved in the incident or in some way associated with it. When you specify a
         *        reference, you enter the Amazon Resource Name (ARN) of the resource. You can also specify a related
         *        item. As an example, you could specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for
         *        this example is the resource. You could also specify a Amazon CloudWatch metric for that table. The
         *        metric is the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventReferences(EventReference... eventReferences);

        /**
         * <p>
         * Adds one or more references to the <code>TimelineEvent</code>. A reference can be an Amazon Web Services
         * resource involved in the incident or in some way associated with it. When you specify a reference, you enter
         * the Amazon Resource Name (ARN) of the resource. You can also specify a related item. As an example, you could
         * specify the ARN of an Amazon DynamoDB (DynamoDB) table. The table for this example is the resource. You could
         * also specify a Amazon CloudWatch metric for that table. The metric is the related item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.EventReference.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmincidents.model.EventReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.EventReference.Builder#build()} is called
         * immediately and its result is passed to {@link #eventReferences(List<EventReference>)}.
         * 
         * @param eventReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.EventReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventReferences(java.util.Collection<EventReference>)
         */
        Builder eventReferences(Consumer<EventReference.Builder>... eventReferences);

        /**
         * <p>
         * The time that the event occurred.
         * </p>
         * 
         * @param eventTime
         *        The time that the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The type of the event. You can create timeline events of type <code>Custom Event</code>.
         * </p>
         * 
         * @param eventType
         *        The type of the event. You can create timeline events of type <code>Custom Event</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident record to which the event will be added.
         * </p>
         * 
         * @param incidentRecordArn
         *        The Amazon Resource Name (ARN) of the incident record to which the event will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordArn(String incidentRecordArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String eventData;

        private List<EventReference> eventReferences = DefaultSdkAutoConstructList.getInstance();

        private Instant eventTime;

        private String eventType;

        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTimelineEventRequest model) {
            super(model);
            clientToken(model.clientToken);
            eventData(model.eventData);
            eventReferences(model.eventReferences);
            eventTime(model.eventTime);
            eventType(model.eventType);
            incidentRecordArn(model.incidentRecordArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEventData() {
            return eventData;
        }

        public final void setEventData(String eventData) {
            this.eventData = eventData;
        }

        @Override
        public final Builder eventData(String eventData) {
            this.eventData = eventData;
            return this;
        }

        public final List<EventReference.Builder> getEventReferences() {
            List<EventReference.Builder> result = EventReferenceListCopier.copyToBuilder(this.eventReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventReferences(Collection<EventReference.BuilderImpl> eventReferences) {
            this.eventReferences = EventReferenceListCopier.copyFromBuilder(eventReferences);
        }

        @Override
        public final Builder eventReferences(Collection<EventReference> eventReferences) {
            this.eventReferences = EventReferenceListCopier.copy(eventReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventReferences(EventReference... eventReferences) {
            eventReferences(Arrays.asList(eventReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventReferences(Consumer<EventReference.Builder>... eventReferences) {
            eventReferences(Stream.of(eventReferences).map(c -> EventReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getIncidentRecordArn() {
            return incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTimelineEventRequest build() {
            return new CreateTimelineEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
