/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details and type of a related item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemIdentifier implements SdkPojo, Serializable, ToCopyableBuilder<ItemIdentifier.Builder, ItemIdentifier> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ItemIdentifier::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ItemValue> VALUE_FIELD = SdkField.<ItemValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(ItemIdentifier::value)).setter(setter(Builder::value))
            .constructor(ItemValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final ItemValue value;

    private ItemIdentifier(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of related item.
     * @see ItemType
     */
    public final ItemType type() {
        return ItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of related item.
     * @see ItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details about the related item.
     * </p>
     * 
     * @return Details about the related item.
     */
    public final ItemValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier other = (ItemIdentifier) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemIdentifier").add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ItemIdentifier, T> g) {
        return obj -> g.apply((ItemIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemIdentifier> {
        /**
         * <p>
         * The type of related item.
         * </p>
         * 
         * @param type
         *        The type of related item.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of related item.
         * </p>
         * 
         * @param type
         *        The type of related item.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(ItemType type);

        /**
         * <p>
         * Details about the related item.
         * </p>
         * 
         * @param value
         *        Details about the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(ItemValue value);

        /**
         * <p>
         * Details about the related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemValue.Builder} avoiding the need to
         * create one manually via {@link ItemValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(ItemValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link ItemValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(ItemValue)
         */
        default Builder value(Consumer<ItemValue.Builder> value) {
            return value(ItemValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ItemValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemIdentifier model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ItemValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(ItemValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ItemValue value) {
            this.value = value;
            return this;
        }

        @Override
        public ItemIdentifier build() {
            return new ItemIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
