/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResponsePlansResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<ListResponsePlansResponse.Builder, ListResponsePlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResponsePlansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ResponsePlanSummary>> RESPONSE_PLAN_SUMMARIES_FIELD = SdkField
            .<List<ResponsePlanSummary>> builder(MarshallingType.LIST)
            .memberName("responsePlanSummaries")
            .getter(getter(ListResponsePlansResponse::responsePlanSummaries))
            .setter(setter(Builder::responsePlanSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsePlanSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponsePlanSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponsePlanSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESPONSE_PLAN_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<ResponsePlanSummary> responsePlanSummaries;

    private ListResponsePlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.responsePlanSummaries = builder.responsePlanSummaries;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponsePlanSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponsePlanSummaries() {
        return responsePlanSummaries != null && !(responsePlanSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of each response plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponsePlanSummaries} method.
     * </p>
     * 
     * @return Details of each response plan.
     */
    public final List<ResponsePlanSummary> responsePlanSummaries() {
        return responsePlanSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponsePlanSummaries() ? responsePlanSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResponsePlansResponse)) {
            return false;
        }
        ListResponsePlansResponse other = (ListResponsePlansResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResponsePlanSummaries() == other.hasResponsePlanSummaries()
                && Objects.equals(responsePlanSummaries(), other.responsePlanSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResponsePlansResponse").add("NextToken", nextToken())
                .add("ResponsePlanSummaries", hasResponsePlanSummaries() ? responsePlanSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "responsePlanSummaries":
            return Optional.ofNullable(clazz.cast(responsePlanSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResponsePlansResponse, T> g) {
        return obj -> g.apply((ListResponsePlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResponsePlansResponse> {
        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details of each response plan.
         * </p>
         * 
         * @param responsePlanSummaries
         *        Details of each response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responsePlanSummaries(Collection<ResponsePlanSummary> responsePlanSummaries);

        /**
         * <p>
         * Details of each response plan.
         * </p>
         * 
         * @param responsePlanSummaries
         *        Details of each response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responsePlanSummaries(ResponsePlanSummary... responsePlanSummaries);

        /**
         * <p>
         * Details of each response plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #responsePlanSummaries(List<ResponsePlanSummary>)}.
         * 
         * @param responsePlanSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responsePlanSummaries(java.util.Collection<ResponsePlanSummary>)
         */
        Builder responsePlanSummaries(Consumer<ResponsePlanSummary.Builder>... responsePlanSummaries);
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResponsePlanSummary> responsePlanSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResponsePlansResponse model) {
            super(model);
            nextToken(model.nextToken);
            responsePlanSummaries(model.responsePlanSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResponsePlanSummary.Builder> getResponsePlanSummaries() {
            List<ResponsePlanSummary.Builder> result = ResponsePlanSummaryListCopier.copyToBuilder(this.responsePlanSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponsePlanSummaries(Collection<ResponsePlanSummary.BuilderImpl> responsePlanSummaries) {
            this.responsePlanSummaries = ResponsePlanSummaryListCopier.copyFromBuilder(responsePlanSummaries);
        }

        @Override
        public final Builder responsePlanSummaries(Collection<ResponsePlanSummary> responsePlanSummaries) {
            this.responsePlanSummaries = ResponsePlanSummaryListCopier.copy(responsePlanSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responsePlanSummaries(ResponsePlanSummary... responsePlanSummaries) {
            responsePlanSummaries(Arrays.asList(responsePlanSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responsePlanSummaries(Consumer<ResponsePlanSummary.Builder>... responsePlanSummaries) {
            responsePlanSummaries(Stream.of(responsePlanSummaries)
                    .map(c -> ResponsePlanSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResponsePlansResponse build() {
            return new ListResponsePlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
