/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTimelineEventsRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<ListTimelineEventsRequest.Builder, ListTimelineEventsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListTimelineEventsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentRecordArn").getter(getter(ListTimelineEventsRequest::incidentRecordArn))
            .setter(setter(Builder::incidentRecordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTimelineEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTimelineEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListTimelineEventsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListTimelineEventsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            INCIDENT_RECORD_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final List<Filter> filters;

    private final String incidentRecordArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListTimelineEventsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.incidentRecordArn = builder.incidentRecordArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the timeline events based on the provided conditional values. You can filter timeline events using the
     * following keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>eventTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>eventType</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note the following when deciding how to use Filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't specify a Filter, the response includes all timeline events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify more than one filter in a single request, the response returns timeline events that match all
     * filters.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a filter with more than one value, the response returns timeline events that match any of the
     * values provided.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters the timeline events based on the provided conditional values. You can filter timeline events
     *         using the following keys:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>eventTime</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>eventType</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Note the following when deciding how to use Filters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you don't specify a Filter, the response includes all timeline events.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify more than one filter in a single request, the response returns timeline events that match
     *         all filters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a filter with more than one value, the response returns timeline events that match any of
     *         the values provided.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident that includes the timeline event.
     */
    public final String incidentRecordArn() {
        return incidentRecordArn;
    }

    /**
     * <p>
     * The maximum number of results per page.
     * </p>
     * 
     * @return The maximum number of results per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Sort by the specified key value pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TimelineEventSort#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort by the specified key value pair.
     * @see TimelineEventSort
     */
    public final TimelineEventSort sortBy() {
        return TimelineEventSort.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort by the specified key value pair.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TimelineEventSort#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort by the specified key value pair.
     * @see TimelineEventSort
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimelineEventsRequest)) {
            return false;
        }
        ListTimelineEventsRequest other = (ListTimelineEventsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(incidentRecordArn(), other.incidentRecordArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTimelineEventsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("IncidentRecordArn", incidentRecordArn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "incidentRecordArn":
            return Optional.ofNullable(clazz.cast(incidentRecordArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTimelineEventsRequest, T> g) {
        return obj -> g.apply((ListTimelineEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTimelineEventsRequest> {
        /**
         * <p>
         * Filters the timeline events based on the provided conditional values. You can filter timeline events using
         * the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>eventTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>eventType</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Note the following when deciding how to use Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify a Filter, the response includes all timeline events.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns timeline events that match all
         * filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter with more than one value, the response returns timeline events that match any of the
         * values provided.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters the timeline events based on the provided conditional values. You can filter timeline events
         *        using the following keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>eventTime</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>eventType</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Note the following when deciding how to use Filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you don't specify a Filter, the response includes all timeline events.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify more than one filter in a single request, the response returns timeline events that
         *        match all filters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a filter with more than one value, the response returns timeline events that match any
         *        of the values provided.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters the timeline events based on the provided conditional values. You can filter timeline events using
         * the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>eventTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>eventType</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Note the following when deciding how to use Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify a Filter, the response includes all timeline events.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns timeline events that match all
         * filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter with more than one value, the response returns timeline events that match any of the
         * values provided.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters the timeline events based on the provided conditional values. You can filter timeline events
         *        using the following keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>eventTime</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>eventType</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Note the following when deciding how to use Filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you don't specify a Filter, the response includes all timeline events.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify more than one filter in a single request, the response returns timeline events that
         *        match all filters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a filter with more than one value, the response returns timeline events that match any
         *        of the values provided.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters the timeline events based on the provided conditional values. You can filter timeline events using
         * the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>eventTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>eventType</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Note the following when deciding how to use Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify a Filter, the response includes all timeline events.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns timeline events that match all
         * filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter with more than one value, the response returns timeline events that match any of the
         * values provided.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmincidents.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Filter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
         * </p>
         * 
         * @param incidentRecordArn
         *        The Amazon Resource Name (ARN) of the incident that includes the timeline event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordArn(String incidentRecordArn);

        /**
         * <p>
         * The maximum number of results per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Sort by the specified key value pair.
         * </p>
         * 
         * @param sortBy
         *        Sort by the specified key value pair.
         * @see TimelineEventSort
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimelineEventSort
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort by the specified key value pair.
         * </p>
         * 
         * @param sortBy
         *        Sort by the specified key value pair.
         * @see TimelineEventSort
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimelineEventSort
         */
        Builder sortBy(TimelineEventSort sortBy);

        /**
         * <p>
         * Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
         * </p>
         * 
         * @param sortOrder
         *        Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
         * </p>
         * 
         * @param sortOrder
         *        Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String incidentRecordArn;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimelineEventsRequest model) {
            super(model);
            filters(model.filters);
            incidentRecordArn(model.incidentRecordArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIncidentRecordArn() {
            return incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TimelineEventSort sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTimelineEventsRequest build() {
            return new ListTimelineEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
