/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTimelineEventsResponse extends SsmIncidentsResponse implements
        ToCopyableBuilder<ListTimelineEventsResponse.Builder, ListTimelineEventsResponse> {
    private static final SdkField<List<EventSummary>> EVENT_SUMMARIES_FIELD = SdkField
            .<List<EventSummary>> builder(MarshallingType.LIST)
            .memberName("eventSummaries")
            .getter(getter(ListTimelineEventsResponse::eventSummaries))
            .setter(setter(Builder::eventSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTimelineEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventSummary> eventSummaries;

    private final String nextToken;

    private ListTimelineEventsResponse(BuilderImpl builder) {
        super(builder);
        this.eventSummaries = builder.eventSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSummaries() {
        return eventSummaries != null && !(eventSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about each event that occurred during the incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSummaries} method.
     * </p>
     * 
     * @return Details about each event that occurred during the incident.
     */
    public final List<EventSummary> eventSummaries() {
        return eventSummaries;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSummaries() ? eventSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimelineEventsResponse)) {
            return false;
        }
        ListTimelineEventsResponse other = (ListTimelineEventsResponse) obj;
        return hasEventSummaries() == other.hasEventSummaries() && Objects.equals(eventSummaries(), other.eventSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTimelineEventsResponse")
                .add("EventSummaries", hasEventSummaries() ? eventSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventSummaries":
            return Optional.ofNullable(clazz.cast(eventSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTimelineEventsResponse, T> g) {
        return obj -> g.apply((ListTimelineEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTimelineEventsResponse> {
        /**
         * <p>
         * Details about each event that occurred during the incident.
         * </p>
         * 
         * @param eventSummaries
         *        Details about each event that occurred during the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSummaries(Collection<EventSummary> eventSummaries);

        /**
         * <p>
         * Details about each event that occurred during the incident.
         * </p>
         * 
         * @param eventSummaries
         *        Details about each event that occurred during the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSummaries(EventSummary... eventSummaries);

        /**
         * <p>
         * Details about each event that occurred during the incident.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.EventSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmincidents.model.EventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.EventSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #eventSummaries(List<EventSummary>)}.
         * 
         * @param eventSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.EventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSummaries(java.util.Collection<EventSummary>)
         */
        Builder eventSummaries(Consumer<EventSummary.Builder>... eventSummaries);

        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmIncidentsResponse.BuilderImpl implements Builder {
        private List<EventSummary> eventSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimelineEventsResponse model) {
            super(model);
            eventSummaries(model.eventSummaries);
            nextToken(model.nextToken);
        }

        public final List<EventSummary.Builder> getEventSummaries() {
            List<EventSummary.Builder> result = EventSummaryListCopier.copyToBuilder(this.eventSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSummaries(Collection<EventSummary.BuilderImpl> eventSummaries) {
            this.eventSummaries = EventSummaryListCopier.copyFromBuilder(eventSummaries);
        }

        @Override
        public final Builder eventSummaries(Collection<EventSummary> eventSummaries) {
            this.eventSummaries = EventSummaryListCopier.copy(eventSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSummaries(EventSummary... eventSummaries) {
            eventSummaries(Arrays.asList(eventSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSummaries(Consumer<EventSummary.Builder>... eventSummaries) {
            eventSummaries(Stream.of(eventSummaries).map(c -> EventSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTimelineEventsResponse build() {
            return new ListTimelineEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
