/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelatedItemsRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<UpdateRelatedItemsRequest.Builder, UpdateRelatedItemsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateRelatedItemsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentRecordArn").getter(getter(UpdateRelatedItemsRequest::incidentRecordArn))
            .setter(setter(Builder::incidentRecordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()).build();

    private static final SdkField<RelatedItemsUpdate> RELATED_ITEMS_UPDATE_FIELD = SdkField
            .<RelatedItemsUpdate> builder(MarshallingType.SDK_POJO).memberName("relatedItemsUpdate")
            .getter(getter(UpdateRelatedItemsRequest::relatedItemsUpdate)).setter(setter(Builder::relatedItemsUpdate))
            .constructor(RelatedItemsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemsUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INCIDENT_RECORD_ARN_FIELD, RELATED_ITEMS_UPDATE_FIELD));

    private final String clientToken;

    private final String incidentRecordArn;

    private final RelatedItemsUpdate relatedItemsUpdate;

    private UpdateRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.incidentRecordArn = builder.incidentRecordArn;
        this.relatedItemsUpdate = builder.relatedItemsUpdate;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident record containing the related items you are updating.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident record containing the related items you are updating.
     */
    public final String incidentRecordArn() {
        return incidentRecordArn;
    }

    /**
     * <p>
     * Details about the item you are adding or deleting.
     * </p>
     * 
     * @return Details about the item you are adding or deleting.
     */
    public final RelatedItemsUpdate relatedItemsUpdate() {
        return relatedItemsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordArn());
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemsUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelatedItemsRequest)) {
            return false;
        }
        UpdateRelatedItemsRequest other = (UpdateRelatedItemsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(incidentRecordArn(), other.incidentRecordArn())
                && Objects.equals(relatedItemsUpdate(), other.relatedItemsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRelatedItemsRequest").add("ClientToken", clientToken())
                .add("IncidentRecordArn", incidentRecordArn()).add("RelatedItemsUpdate", relatedItemsUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "incidentRecordArn":
            return Optional.ofNullable(clazz.cast(incidentRecordArn()));
        case "relatedItemsUpdate":
            return Optional.ofNullable(clazz.cast(relatedItemsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelatedItemsRequest, T> g) {
        return obj -> g.apply((UpdateRelatedItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRelatedItemsRequest> {
        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident record containing the related items you are updating.
         * </p>
         * 
         * @param incidentRecordArn
         *        The Amazon Resource Name (ARN) of the incident record containing the related items you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordArn(String incidentRecordArn);

        /**
         * <p>
         * Details about the item you are adding or deleting.
         * </p>
         * 
         * @param relatedItemsUpdate
         *        Details about the item you are adding or deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemsUpdate(RelatedItemsUpdate relatedItemsUpdate);

        /**
         * <p>
         * Details about the item you are adding or deleting.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedItemsUpdate.Builder} avoiding the
         * need to create one manually via {@link RelatedItemsUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedItemsUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #relatedItemsUpdate(RelatedItemsUpdate)}.
         * 
         * @param relatedItemsUpdate
         *        a consumer that will call methods on {@link RelatedItemsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedItemsUpdate(RelatedItemsUpdate)
         */
        default Builder relatedItemsUpdate(Consumer<RelatedItemsUpdate.Builder> relatedItemsUpdate) {
            return relatedItemsUpdate(RelatedItemsUpdate.builder().applyMutation(relatedItemsUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String incidentRecordArn;

        private RelatedItemsUpdate relatedItemsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelatedItemsRequest model) {
            super(model);
            clientToken(model.clientToken);
            incidentRecordArn(model.incidentRecordArn);
            relatedItemsUpdate(model.relatedItemsUpdate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIncidentRecordArn() {
            return incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        public final RelatedItemsUpdate.Builder getRelatedItemsUpdate() {
            return relatedItemsUpdate != null ? relatedItemsUpdate.toBuilder() : null;
        }

        public final void setRelatedItemsUpdate(RelatedItemsUpdate.BuilderImpl relatedItemsUpdate) {
            this.relatedItemsUpdate = relatedItemsUpdate != null ? relatedItemsUpdate.build() : null;
        }

        @Override
        public final Builder relatedItemsUpdate(RelatedItemsUpdate relatedItemsUpdate) {
            this.relatedItemsUpdate = relatedItemsUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelatedItemsRequest build() {
            return new UpdateRelatedItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
