/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ssmincidents.model.ResourcePolicy;

public class GetResourcePoliciesPublisher
implements SdkPublisher<GetResourcePoliciesResponse> {
    private final SsmIncidentsAsyncClient client;
    private final GetResourcePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcePoliciesPublisher(SsmIncidentsAsyncClient client, GetResourcePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcePoliciesPublisher(SsmIncidentsAsyncClient client, GetResourcePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourcePolicy> resourcePolicies() {
        Function<GetResourcePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourcePolicies() != null) {
                return response.resourcePolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcePoliciesResponseFetcher
    implements AsyncPageFetcher<GetResourcePoliciesResponse> {
        private GetResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourcePoliciesResponse> nextPage(GetResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcePoliciesPublisher.this.client.getResourcePolicies(GetResourcePoliciesPublisher.this.firstRequest);
            }
            return GetResourcePoliciesPublisher.this.client.getResourcePolicies((GetResourcePoliciesRequest)((Object)GetResourcePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

