/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.services.ssmincidents.waiters.SsmIncidentsWaiter;
import software.amazon.awssdk.services.ssmincidents.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultSsmIncidentsWaiter
implements SsmIncidentsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final SsmIncidentsClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetReplicationSetResponse> waitForReplicationSetActiveWaiter;
    private final Waiter<GetReplicationSetResponse> waitForReplicationSetDeletedWaiter;

    private DefaultSsmIncidentsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SsmIncidentsClient)SsmIncidentsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.waitForReplicationSetActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReplicationSetResponse.class).acceptors(DefaultSsmIncidentsWaiter.waitForReplicationSetActiveWaiterAcceptors())).overrideConfiguration(DefaultSsmIncidentsWaiter.waitForReplicationSetActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.waitForReplicationSetDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetReplicationSetResponse.class).acceptors(DefaultSsmIncidentsWaiter.waitForReplicationSetDeletedWaiterAcceptors())).overrideConfiguration(DefaultSsmIncidentsWaiter.waitForReplicationSetDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetReplicationSetResponse> waitUntilWaitForReplicationSetActive(GetReplicationSetRequest getReplicationSetRequest) {
        return this.waitForReplicationSetActiveWaiter.run(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)));
    }

    @Override
    public WaiterResponse<GetReplicationSetResponse> waitUntilWaitForReplicationSetActive(GetReplicationSetRequest getReplicationSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.waitForReplicationSetActiveWaiter.run(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)), DefaultSsmIncidentsWaiter.waitForReplicationSetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReplicationSetResponse> waitUntilWaitForReplicationSetDeleted(GetReplicationSetRequest getReplicationSetRequest) {
        return this.waitForReplicationSetDeletedWaiter.run(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)));
    }

    @Override
    public WaiterResponse<GetReplicationSetResponse> waitUntilWaitForReplicationSetDeleted(GetReplicationSetRequest getReplicationSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.waitForReplicationSetDeletedWaiter.run(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)), DefaultSsmIncidentsWaiter.waitForReplicationSetDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetReplicationSetResponse>> waitForReplicationSetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>> result = new ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReplicationSetResponse>> waitForReplicationSetDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>> result = new ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSsmIncidentsWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration waitForReplicationSetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration waitForReplicationSetDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SsmIncidentsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SsmIncidentsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SsmIncidentsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SsmIncidentsWaiter.Builder {
        private SsmIncidentsClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public SsmIncidentsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SsmIncidentsWaiter.Builder client(SsmIncidentsClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SsmIncidentsWaiter build() {
            return new DefaultSsmIncidentsWaiter(this);
        }
    }
}

