/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an CloudFormation stack creation or update that occurred around the time of an incident and could
 * be a potential cause of the incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFormationStackUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFormationStackUpdate.Builder, CloudFormationStackUpdate> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(CloudFormationStackUpdate::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackArn").getter(getter(CloudFormationStackUpdate::stackArn)).setter(setter(Builder::stackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CloudFormationStackUpdate::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            STACK_ARN_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String stackArn;

    private final Instant startTime;

    private CloudFormationStackUpdate(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.stackArn = builder.stackArn;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The timestamp for when the CloudFormation stack creation or update ended. Not reported for deployments that are
     * still in progress.
     * </p>
     * 
     * @return The timestamp for when the CloudFormation stack creation or update ended. Not reported for deployments
     *         that are still in progress.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudFormation stack involved in the update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudFormation stack involved in the update.
     */
    public final String stackArn() {
        return stackArn;
    }

    /**
     * <p>
     * The timestamp for when the CloudFormation stack creation or update began.
     * </p>
     * 
     * @return The timestamp for when the CloudFormation stack creation or update began.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(stackArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationStackUpdate)) {
            return false;
        }
        CloudFormationStackUpdate other = (CloudFormationStackUpdate) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(stackArn(), other.stackArn())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFormationStackUpdate").add("EndTime", endTime()).add("StackArn", stackArn())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "stackArn":
            return Optional.ofNullable(clazz.cast(stackArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationStackUpdate, T> g) {
        return obj -> g.apply((CloudFormationStackUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFormationStackUpdate> {
        /**
         * <p>
         * The timestamp for when the CloudFormation stack creation or update ended. Not reported for deployments that
         * are still in progress.
         * </p>
         * 
         * @param endTime
         *        The timestamp for when the CloudFormation stack creation or update ended. Not reported for deployments
         *        that are still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudFormation stack involved in the update.
         * </p>
         * 
         * @param stackArn
         *        The Amazon Resource Name (ARN) of the CloudFormation stack involved in the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackArn(String stackArn);

        /**
         * <p>
         * The timestamp for when the CloudFormation stack creation or update began.
         * </p>
         * 
         * @param startTime
         *        The timestamp for when the CloudFormation stack creation or update began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String stackArn;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationStackUpdate model) {
            endTime(model.endTime);
            stackArn(model.stackArn);
            startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStackArn() {
            return stackArn;
        }

        public final void setStackArn(String stackArn) {
            this.stackArn = stackArn;
        }

        @Override
        public final Builder stackArn(String stackArn) {
            this.stackArn = stackArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public CloudFormationStackUpdate build() {
            return new CloudFormationStackUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
