/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a CodeDeploy deployment that occurred around the time of an incident and could be a possible cause
 * of the incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeDeployDeployment implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeDeployDeployment.Builder, CodeDeployDeployment> {
    private static final SdkField<String> DEPLOYMENT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupArn").getter(getter(CodeDeployDeployment::deploymentGroupArn))
            .setter(setter(Builder::deploymentGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupArn").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(CodeDeployDeployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(CodeDeployDeployment::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CodeDeployDeployment::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_GROUP_ARN_FIELD,
            DEPLOYMENT_ID_FIELD, END_TIME_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentGroupArn;

    private final String deploymentId;

    private final Instant endTime;

    private final Instant startTime;

    private CodeDeployDeployment(BuilderImpl builder) {
        this.deploymentGroupArn = builder.deploymentGroupArn;
        this.deploymentId = builder.deploymentId;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CodeDeploy deployment group associated with the deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CodeDeploy deployment group associated with the deployment.
     */
    public final String deploymentGroupArn() {
        return deploymentGroupArn;
    }

    /**
     * <p>
     * The ID of the CodeDeploy deployment.
     * </p>
     * 
     * @return The ID of the CodeDeploy deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The timestamp for when the CodeDeploy deployment ended. Not reported for deployments that are still in progress.
     * </p>
     * 
     * @return The timestamp for when the CodeDeploy deployment ended. Not reported for deployments that are still in
     *         progress.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The timestamp for when the CodeDeploy deployment began.
     * </p>
     * 
     * @return The timestamp for when the CodeDeploy deployment began.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeDeployDeployment)) {
            return false;
        }
        CodeDeployDeployment other = (CodeDeployDeployment) obj;
        return Objects.equals(deploymentGroupArn(), other.deploymentGroupArn())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeDeployDeployment").add("DeploymentGroupArn", deploymentGroupArn())
                .add("DeploymentId", deploymentId()).add("EndTime", endTime()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentGroupArn":
            return Optional.ofNullable(clazz.cast(deploymentGroupArn()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeDeployDeployment, T> g) {
        return obj -> g.apply((CodeDeployDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeDeployDeployment> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CodeDeploy deployment group associated with the deployment.
         * </p>
         * 
         * @param deploymentGroupArn
         *        The Amazon Resource Name (ARN) of the CodeDeploy deployment group associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupArn(String deploymentGroupArn);

        /**
         * <p>
         * The ID of the CodeDeploy deployment.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the CodeDeploy deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The timestamp for when the CodeDeploy deployment ended. Not reported for deployments that are still in
         * progress.
         * </p>
         * 
         * @param endTime
         *        The timestamp for when the CodeDeploy deployment ended. Not reported for deployments that are still in
         *        progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The timestamp for when the CodeDeploy deployment began.
         * </p>
         * 
         * @param startTime
         *        The timestamp for when the CodeDeploy deployment began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentGroupArn;

        private String deploymentId;

        private Instant endTime;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeDeployDeployment model) {
            deploymentGroupArn(model.deploymentGroupArn);
            deploymentId(model.deploymentId);
            endTime(model.endTime);
            startTime(model.startTime);
        }

        public final String getDeploymentGroupArn() {
            return deploymentGroupArn;
        }

        public final void setDeploymentGroupArn(String deploymentGroupArn) {
            this.deploymentGroupArn = deploymentGroupArn;
        }

        @Override
        public final Builder deploymentGroupArn(String deploymentGroupArn) {
            this.deploymentGroupArn = deploymentGroupArn;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public CodeDeployDeployment build() {
            return new CodeDeployDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
