/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class DynamicSsmParametersCopier {
    static Map<String, DynamicSsmParameterValue> copy(Map<String, ? extends DynamicSsmParameterValue> dynamicSsmParametersParam) {
        Map<String, DynamicSsmParameterValue> map;
        if (dynamicSsmParametersParam == null || dynamicSsmParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DynamicSsmParameterValue> modifiableMap = new LinkedHashMap<>();
            dynamicSsmParametersParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DynamicSsmParameterValue> copyFromBuilder(
            Map<String, ? extends DynamicSsmParameterValue.Builder> dynamicSsmParametersParam) {
        Map<String, DynamicSsmParameterValue> map;
        if (dynamicSsmParametersParam == null || dynamicSsmParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DynamicSsmParameterValue> modifiableMap = new LinkedHashMap<>();
            dynamicSsmParametersParam.forEach((key, value) -> {
                DynamicSsmParameterValue member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DynamicSsmParameterValue.Builder> copyToBuilder(
            Map<String, ? extends DynamicSsmParameterValue> dynamicSsmParametersParam) {
        Map<String, DynamicSsmParameterValue.Builder> map;
        if (dynamicSsmParametersParam == null || dynamicSsmParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DynamicSsmParameterValue.Builder> modifiableMap = new LinkedHashMap<>();
            dynamicSsmParametersParam.forEach((key, value) -> {
                DynamicSsmParameterValue.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
