/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a specific CodeDeploy deployment or CloudFormation stack creation or update that occurred around
 * the time of a reported incident. These activities can be investigated as a potential cause of the incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Finding::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<FindingDetails> DETAILS_FIELD = SdkField.<FindingDetails> builder(MarshallingType.SDK_POJO)
            .memberName("details").getter(getter(Finding::details)).setter(setter(Builder::details))
            .constructor(FindingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Finding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime").getter(getter(Finding::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DETAILS_FIELD, ID_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final FindingDetails details;

    private final String id;

    private final Instant lastModifiedTime;

    private Finding(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.details = builder.details;
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The timestamp for when a finding was created.
     * </p>
     * 
     * @return The timestamp for when a finding was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Details about the finding.
     * </p>
     * 
     * @return Details about the finding.
     */
    public final FindingDetails details() {
        return details;
    }

    /**
     * <p>
     * The ID assigned to the finding.
     * </p>
     * 
     * @return The ID assigned to the finding.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp for when the finding was most recently updated with additional information.
     * </p>
     * 
     * @return The timestamp for when the finding was most recently updated with additional information.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(details(), other.details())
                && Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Finding").add("CreationTime", creationTime()).add("Details", details()).add("Id", id())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The timestamp for when a finding was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp for when a finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Details about the finding.
         * </p>
         * 
         * @param details
         *        Details about the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(FindingDetails details);

        /**
         * <p>
         * Details about the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingDetails.Builder} avoiding the need
         * to create one manually via {@link FindingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(FindingDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link FindingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(FindingDetails)
         */
        default Builder details(Consumer<FindingDetails.Builder> details) {
            return details(FindingDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The ID assigned to the finding.
         * </p>
         * 
         * @param id
         *        The ID assigned to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp for when the finding was most recently updated with additional information.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp for when the finding was most recently updated with additional information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private FindingDetails details;

        private String id;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            creationTime(model.creationTime);
            details(model.details);
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final FindingDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(FindingDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(FindingDetails details) {
            this.details = details;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
