/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details describing an incident record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncidentRecordSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IncidentRecordSummary.Builder, IncidentRecordSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IncidentRecordSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(IncidentRecordSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Integer> IMPACT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("impact").getter(getter(IncidentRecordSummary::impact)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()).build();

    private static final SdkField<IncidentRecordSource> INCIDENT_RECORD_SOURCE_FIELD = SdkField
            .<IncidentRecordSource> builder(MarshallingType.SDK_POJO).memberName("incidentRecordSource")
            .getter(getter(IncidentRecordSummary::incidentRecordSource)).setter(setter(Builder::incidentRecordSource))
            .constructor(IncidentRecordSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordSource").build())
            .build();

    private static final SdkField<Instant> RESOLVED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("resolvedTime").getter(getter(IncidentRecordSummary::resolvedTime)).setter(setter(Builder::resolvedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(IncidentRecordSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(IncidentRecordSummary::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, IMPACT_FIELD, INCIDENT_RECORD_SOURCE_FIELD, RESOLVED_TIME_FIELD, STATUS_FIELD, TITLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationTime;

    private final Integer impact;

    private final IncidentRecordSource incidentRecordSource;

    private final Instant resolvedTime;

    private final String status;

    private final String title;

    private IncidentRecordSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.impact = builder.impact;
        this.incidentRecordSource = builder.incidentRecordSource;
        this.resolvedTime = builder.resolvedTime;
        this.status = builder.status;
        this.title = builder.title;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp for when the incident was created.
     * </p>
     * 
     * @return The timestamp for when the incident was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Defines the impact to customers and applications.
     * </p>
     * 
     * @return Defines the impact to customers and applications.
     */
    public final Integer impact() {
        return impact;
    }

    /**
     * <p>
     * What caused Incident Manager to create the incident.
     * </p>
     * 
     * @return What caused Incident Manager to create the incident.
     */
    public final IncidentRecordSource incidentRecordSource() {
        return incidentRecordSource;
    }

    /**
     * <p>
     * The timestamp for when the incident was resolved.
     * </p>
     * 
     * @return The timestamp for when the incident was resolved.
     */
    public final Instant resolvedTime() {
        return resolvedTime;
    }

    /**
     * <p>
     * The current status of the incident.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IncidentRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the incident.
     * @see IncidentRecordStatus
     */
    public final IncidentRecordStatus status() {
        return IncidentRecordStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the incident.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IncidentRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the incident.
     * @see IncidentRecordStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The title of the incident. This value is either provided by the response plan or overwritten on creation.
     * </p>
     * 
     * @return The title of the incident. This value is either provided by the response plan or overwritten on creation.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(impact());
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordSource());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentRecordSummary)) {
            return false;
        }
        IncidentRecordSummary other = (IncidentRecordSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(impact(), other.impact())
                && Objects.equals(incidentRecordSource(), other.incidentRecordSource())
                && Objects.equals(resolvedTime(), other.resolvedTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncidentRecordSummary").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Impact", impact()).add("IncidentRecordSource", incidentRecordSource()).add("ResolvedTime", resolvedTime())
                .add("Status", statusAsString()).add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "impact":
            return Optional.ofNullable(clazz.cast(impact()));
        case "incidentRecordSource":
            return Optional.ofNullable(clazz.cast(incidentRecordSource()));
        case "resolvedTime":
            return Optional.ofNullable(clazz.cast(resolvedTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncidentRecordSummary, T> g) {
        return obj -> g.apply((IncidentRecordSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncidentRecordSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp for when the incident was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp for when the incident was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Defines the impact to customers and applications.
         * </p>
         * 
         * @param impact
         *        Defines the impact to customers and applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impact(Integer impact);

        /**
         * <p>
         * What caused Incident Manager to create the incident.
         * </p>
         * 
         * @param incidentRecordSource
         *        What caused Incident Manager to create the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordSource(IncidentRecordSource incidentRecordSource);

        /**
         * <p>
         * What caused Incident Manager to create the incident.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncidentRecordSource.Builder} avoiding
         * the need to create one manually via {@link IncidentRecordSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncidentRecordSource.Builder#build()} is called immediately and
         * its result is passed to {@link #incidentRecordSource(IncidentRecordSource)}.
         * 
         * @param incidentRecordSource
         *        a consumer that will call methods on {@link IncidentRecordSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentRecordSource(IncidentRecordSource)
         */
        default Builder incidentRecordSource(Consumer<IncidentRecordSource.Builder> incidentRecordSource) {
            return incidentRecordSource(IncidentRecordSource.builder().applyMutation(incidentRecordSource).build());
        }

        /**
         * <p>
         * The timestamp for when the incident was resolved.
         * </p>
         * 
         * @param resolvedTime
         *        The timestamp for when the incident was resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedTime(Instant resolvedTime);

        /**
         * <p>
         * The current status of the incident.
         * </p>
         * 
         * @param status
         *        The current status of the incident.
         * @see IncidentRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncidentRecordStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the incident.
         * </p>
         * 
         * @param status
         *        The current status of the incident.
         * @see IncidentRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncidentRecordStatus
         */
        Builder status(IncidentRecordStatus status);

        /**
         * <p>
         * The title of the incident. This value is either provided by the response plan or overwritten on creation.
         * </p>
         * 
         * @param title
         *        The title of the incident. This value is either provided by the response plan or overwritten on
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private Integer impact;

        private IncidentRecordSource incidentRecordSource;

        private Instant resolvedTime;

        private String status;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentRecordSummary model) {
            arn(model.arn);
            creationTime(model.creationTime);
            impact(model.impact);
            incidentRecordSource(model.incidentRecordSource);
            resolvedTime(model.resolvedTime);
            status(model.status);
            title(model.title);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getImpact() {
            return impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final IncidentRecordSource.Builder getIncidentRecordSource() {
            return incidentRecordSource != null ? incidentRecordSource.toBuilder() : null;
        }

        public final void setIncidentRecordSource(IncidentRecordSource.BuilderImpl incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource != null ? incidentRecordSource.build() : null;
        }

        @Override
        public final Builder incidentRecordSource(IncidentRecordSource incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource;
            return this;
        }

        public final Instant getResolvedTime() {
            return resolvedTime;
        }

        public final void setResolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
        }

        @Override
        public final Builder resolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IncidentRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public IncidentRecordSummary build() {
            return new IncidentRecordSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
