/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about what caused the incident to be created in Incident Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerDetails implements SdkPojo, Serializable, ToCopyableBuilder<TriggerDetails.Builder, TriggerDetails> {
    private static final SdkField<String> RAW_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawData").getter(getter(TriggerDetails::rawData)).setter(setter(Builder::rawData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawData").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(TriggerDetails::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(TriggerDetails::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> TRIGGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerArn").getter(getter(TriggerDetails::triggerArn)).setter(setter(Builder::triggerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_DATA_FIELD, SOURCE_FIELD,
            TIMESTAMP_FIELD, TRIGGER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rawData;

    private final String source;

    private final Instant timestamp;

    private final String triggerArn;

    private TriggerDetails(BuilderImpl builder) {
        this.rawData = builder.rawData;
        this.source = builder.source;
        this.timestamp = builder.timestamp;
        this.triggerArn = builder.triggerArn;
    }

    /**
     * <p>
     * Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is
     * created.
     * </p>
     * 
     * @return Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident
     *         is created.
     */
    public final String rawData() {
        return rawData;
    }

    /**
     * <p>
     * Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "
     * <code>aws.</code>" Customer-generated events can have any value here, as long as it doesn't begin with "
     * <code>aws.</code>" We recommend the use of Java package-name style reverse domain-name strings.
     * </p>
     * 
     * @return Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin
     *         with "<code>aws.</code>
     *         " Customer-generated events can have any value here, as long as it doesn't begin with "<code>aws.</code>"
     *         We recommend the use of Java package-name style reverse domain-name strings.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The timestamp for when the incident was detected.
     * </p>
     * 
     * @return The timestamp for when the incident was detected.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source that detected the incident.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source that detected the incident.
     */
    public final String triggerArn() {
        return triggerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rawData());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(triggerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerDetails)) {
            return false;
        }
        TriggerDetails other = (TriggerDetails) obj;
        return Objects.equals(rawData(), other.rawData()) && Objects.equals(source(), other.source())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(triggerArn(), other.triggerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerDetails").add("RawData", rawData()).add("Source", source()).add("Timestamp", timestamp())
                .add("TriggerArn", triggerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rawData":
            return Optional.ofNullable(clazz.cast(rawData()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "triggerArn":
            return Optional.ofNullable(clazz.cast(triggerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerDetails, T> g) {
        return obj -> g.apply((TriggerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerDetails> {
        /**
         * <p>
         * Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is
         * created.
         * </p>
         * 
         * @param rawData
         *        Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an
         *        incident is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawData(String rawData);

        /**
         * <p>
         * Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with
         * "<code>aws.</code>" Customer-generated events can have any value here, as long as it doesn't begin with "
         * <code>aws.</code>" We recommend the use of Java package-name style reverse domain-name strings.
         * </p>
         * 
         * @param source
         *        Identifies the service that sourced the event. All events sourced from within Amazon Web Services
         *        begin with "<code>aws.</code>
         *        " Customer-generated events can have any value here, as long as it doesn't begin with "
         *        <code>aws.</code>" We recommend the use of Java package-name style reverse domain-name strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The timestamp for when the incident was detected.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for when the incident was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source that detected the incident.
         * </p>
         * 
         * @param triggerArn
         *        The Amazon Resource Name (ARN) of the source that detected the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerArn(String triggerArn);
    }

    static final class BuilderImpl implements Builder {
        private String rawData;

        private String source;

        private Instant timestamp;

        private String triggerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerDetails model) {
            rawData(model.rawData);
            source(model.source);
            timestamp(model.timestamp);
            triggerArn(model.triggerArn);
        }

        public final String getRawData() {
            return rawData;
        }

        public final void setRawData(String rawData) {
            this.rawData = rawData;
        }

        @Override
        public final Builder rawData(String rawData) {
            this.rawData = rawData;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getTriggerArn() {
            return triggerArn;
        }

        public final void setTriggerArn(String triggerArn) {
            this.triggerArn = triggerArn;
        }

        @Override
        public final Builder triggerArn(String triggerArn) {
            this.triggerArn = triggerArn;
            return this;
        }

        @Override
        public TriggerDetails build() {
            return new TriggerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
