/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsResponse;

public class ListIncidentRecordsIterable
implements SdkIterable<ListIncidentRecordsResponse> {
    private final SsmIncidentsClient client;
    private final ListIncidentRecordsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIncidentRecordsIterable(SsmIncidentsClient client, ListIncidentRecordsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIncidentRecordsResponseFetcher();
    }

    public Iterator<ListIncidentRecordsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IncidentRecordSummary> incidentRecordSummaries() {
        Function<ListIncidentRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.incidentRecordSummaries() != null) {
                return response.incidentRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIncidentRecordsResponseFetcher
    implements SyncPageFetcher<ListIncidentRecordsResponse> {
        private ListIncidentRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListIncidentRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIncidentRecordsResponse nextPage(ListIncidentRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListIncidentRecordsIterable.this.client.listIncidentRecords(ListIncidentRecordsIterable.this.firstRequest);
            }
            return ListIncidentRecordsIterable.this.client.listIncidentRecords((ListIncidentRecordsRequest)((Object)ListIncidentRecordsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

