/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extended textual information about the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingDetails implements SdkPojo, Serializable, ToCopyableBuilder<FindingDetails.Builder, FindingDetails> {
    private static final SdkField<CloudFormationStackUpdate> CLOUD_FORMATION_STACK_UPDATE_FIELD = SdkField
            .<CloudFormationStackUpdate> builder(MarshallingType.SDK_POJO).memberName("cloudFormationStackUpdate")
            .getter(getter(FindingDetails::cloudFormationStackUpdate)).setter(setter(Builder::cloudFormationStackUpdate))
            .constructor(CloudFormationStackUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationStackUpdate").build())
            .build();

    private static final SdkField<CodeDeployDeployment> CODE_DEPLOY_DEPLOYMENT_FIELD = SdkField
            .<CodeDeployDeployment> builder(MarshallingType.SDK_POJO).memberName("codeDeployDeployment")
            .getter(getter(FindingDetails::codeDeployDeployment)).setter(setter(Builder::codeDeployDeployment))
            .constructor(CodeDeployDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeDeployDeployment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_FORMATION_STACK_UPDATE_FIELD, CODE_DEPLOY_DEPLOYMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudFormationStackUpdate cloudFormationStackUpdate;

    private final CodeDeployDeployment codeDeployDeployment;

    private final Type type;

    private FindingDetails(BuilderImpl builder) {
        this.cloudFormationStackUpdate = builder.cloudFormationStackUpdate;
        this.codeDeployDeployment = builder.codeDeployDeployment;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about the CloudFormation stack creation or update associated with the finding.
     * </p>
     * 
     * @return Information about the CloudFormation stack creation or update associated with the finding.
     */
    public final CloudFormationStackUpdate cloudFormationStackUpdate() {
        return cloudFormationStackUpdate;
    }

    /**
     * <p>
     * Information about the CodeDeploy deployment associated with the finding.
     * </p>
     * 
     * @return Information about the CodeDeploy deployment associated with the finding.
     */
    public final CodeDeployDeployment codeDeployDeployment() {
        return codeDeployDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationStackUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeployDeployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetails)) {
            return false;
        }
        FindingDetails other = (FindingDetails) obj;
        return Objects.equals(cloudFormationStackUpdate(), other.cloudFormationStackUpdate())
                && Objects.equals(codeDeployDeployment(), other.codeDeployDeployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingDetails").add("CloudFormationStackUpdate", cloudFormationStackUpdate())
                .add("CodeDeployDeployment", codeDeployDeployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudFormationStackUpdate":
            return Optional.ofNullable(clazz.cast(cloudFormationStackUpdate()));
        case "codeDeployDeployment":
            return Optional.ofNullable(clazz.cast(codeDeployDeployment()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cloudFormationStackUpdate()} initialized to the given value.
     *
     * <p>
     * Information about the CloudFormation stack creation or update associated with the finding.
     * </p>
     * 
     * @param cloudFormationStackUpdate
     *        Information about the CloudFormation stack creation or update associated with the finding.
     */
    public static FindingDetails fromCloudFormationStackUpdate(CloudFormationStackUpdate cloudFormationStackUpdate) {
        return builder().cloudFormationStackUpdate(cloudFormationStackUpdate).build();
    }

    /**
     * Create an instance of this class with {@link #cloudFormationStackUpdate()} initialized to the given value.
     *
     * <p>
     * Information about the CloudFormation stack creation or update associated with the finding.
     * </p>
     * 
     * @param cloudFormationStackUpdate
     *        Information about the CloudFormation stack creation or update associated with the finding.
     */
    public static FindingDetails fromCloudFormationStackUpdate(
            Consumer<CloudFormationStackUpdate.Builder> cloudFormationStackUpdate) {
        CloudFormationStackUpdate.Builder builder = CloudFormationStackUpdate.builder();
        cloudFormationStackUpdate.accept(builder);
        return fromCloudFormationStackUpdate(builder.build());
    }

    /**
     * Create an instance of this class with {@link #codeDeployDeployment()} initialized to the given value.
     *
     * <p>
     * Information about the CodeDeploy deployment associated with the finding.
     * </p>
     * 
     * @param codeDeployDeployment
     *        Information about the CodeDeploy deployment associated with the finding.
     */
    public static FindingDetails fromCodeDeployDeployment(CodeDeployDeployment codeDeployDeployment) {
        return builder().codeDeployDeployment(codeDeployDeployment).build();
    }

    /**
     * Create an instance of this class with {@link #codeDeployDeployment()} initialized to the given value.
     *
     * <p>
     * Information about the CodeDeploy deployment associated with the finding.
     * </p>
     * 
     * @param codeDeployDeployment
     *        Information about the CodeDeploy deployment associated with the finding.
     */
    public static FindingDetails fromCodeDeployDeployment(Consumer<CodeDeployDeployment.Builder> codeDeployDeployment) {
        CodeDeployDeployment.Builder builder = CodeDeployDeployment.builder();
        codeDeployDeployment.accept(builder);
        return fromCodeDeployDeployment(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingDetails, T> g) {
        return obj -> g.apply((FindingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingDetails> {
        /**
         * <p>
         * Information about the CloudFormation stack creation or update associated with the finding.
         * </p>
         * 
         * @param cloudFormationStackUpdate
         *        Information about the CloudFormation stack creation or update associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationStackUpdate(CloudFormationStackUpdate cloudFormationStackUpdate);

        /**
         * <p>
         * Information about the CloudFormation stack creation or update associated with the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudFormationStackUpdate.Builder}
         * avoiding the need to create one manually via {@link CloudFormationStackUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFormationStackUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFormationStackUpdate(CloudFormationStackUpdate)}.
         * 
         * @param cloudFormationStackUpdate
         *        a consumer that will call methods on {@link CloudFormationStackUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationStackUpdate(CloudFormationStackUpdate)
         */
        default Builder cloudFormationStackUpdate(Consumer<CloudFormationStackUpdate.Builder> cloudFormationStackUpdate) {
            return cloudFormationStackUpdate(CloudFormationStackUpdate.builder().applyMutation(cloudFormationStackUpdate).build());
        }

        /**
         * <p>
         * Information about the CodeDeploy deployment associated with the finding.
         * </p>
         * 
         * @param codeDeployDeployment
         *        Information about the CodeDeploy deployment associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeployDeployment(CodeDeployDeployment codeDeployDeployment);

        /**
         * <p>
         * Information about the CodeDeploy deployment associated with the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeDeployDeployment.Builder} avoiding
         * the need to create one manually via {@link CodeDeployDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeDeployDeployment.Builder#build()} is called immediately and
         * its result is passed to {@link #codeDeployDeployment(CodeDeployDeployment)}.
         * 
         * @param codeDeployDeployment
         *        a consumer that will call methods on {@link CodeDeployDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeployDeployment(CodeDeployDeployment)
         */
        default Builder codeDeployDeployment(Consumer<CodeDeployDeployment.Builder> codeDeployDeployment) {
            return codeDeployDeployment(CodeDeployDeployment.builder().applyMutation(codeDeployDeployment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationStackUpdate cloudFormationStackUpdate;

        private CodeDeployDeployment codeDeployDeployment;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetails model) {
            cloudFormationStackUpdate(model.cloudFormationStackUpdate);
            codeDeployDeployment(model.codeDeployDeployment);
        }

        public final CloudFormationStackUpdate.Builder getCloudFormationStackUpdate() {
            return cloudFormationStackUpdate != null ? cloudFormationStackUpdate.toBuilder() : null;
        }

        public final void setCloudFormationStackUpdate(CloudFormationStackUpdate.BuilderImpl cloudFormationStackUpdate) {
            Object oldValue = this.cloudFormationStackUpdate;
            this.cloudFormationStackUpdate = cloudFormationStackUpdate != null ? cloudFormationStackUpdate.build() : null;
            handleUnionValueChange(Type.CLOUD_FORMATION_STACK_UPDATE, oldValue, this.cloudFormationStackUpdate);
        }

        @Override
        public final Builder cloudFormationStackUpdate(CloudFormationStackUpdate cloudFormationStackUpdate) {
            Object oldValue = this.cloudFormationStackUpdate;
            this.cloudFormationStackUpdate = cloudFormationStackUpdate;
            handleUnionValueChange(Type.CLOUD_FORMATION_STACK_UPDATE, oldValue, this.cloudFormationStackUpdate);
            return this;
        }

        public final CodeDeployDeployment.Builder getCodeDeployDeployment() {
            return codeDeployDeployment != null ? codeDeployDeployment.toBuilder() : null;
        }

        public final void setCodeDeployDeployment(CodeDeployDeployment.BuilderImpl codeDeployDeployment) {
            Object oldValue = this.codeDeployDeployment;
            this.codeDeployDeployment = codeDeployDeployment != null ? codeDeployDeployment.build() : null;
            handleUnionValueChange(Type.CODE_DEPLOY_DEPLOYMENT, oldValue, this.codeDeployDeployment);
        }

        @Override
        public final Builder codeDeployDeployment(CodeDeployDeployment codeDeployDeployment) {
            Object oldValue = this.codeDeployDeployment;
            this.codeDeployDeployment = codeDeployDeployment;
            handleUnionValueChange(Type.CODE_DEPLOY_DEPLOYMENT, oldValue, this.codeDeployDeployment);
            return this;
        }

        @Override
        public FindingDetails build() {
            return new FindingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FindingDetails#type()
     */
    public enum Type {
        CLOUD_FORMATION_STACK_UPDATE,

        CODE_DEPLOY_DEPLOYMENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
