/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a related item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemValue implements SdkPojo, Serializable, ToCopyableBuilder<ItemValue.Builder, ItemValue> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ItemValue::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> METRIC_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricDefinition").getter(getter(ItemValue::metricDefinition)).setter(setter(Builder::metricDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinition").build()).build();

    private static final SdkField<PagerDutyIncidentDetail> PAGER_DUTY_INCIDENT_DETAIL_FIELD = SdkField
            .<PagerDutyIncidentDetail> builder(MarshallingType.SDK_POJO).memberName("pagerDutyIncidentDetail")
            .getter(getter(ItemValue::pagerDutyIncidentDetail)).setter(setter(Builder::pagerDutyIncidentDetail))
            .constructor(PagerDutyIncidentDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pagerDutyIncidentDetail").build())
            .build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(ItemValue::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            METRIC_DEFINITION_FIELD, PAGER_DUTY_INCIDENT_DETAIL_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String metricDefinition;

    private final PagerDutyIncidentDetail pagerDutyIncidentDetail;

    private final String url;

    private final Type type;

    private ItemValue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.metricDefinition = builder.metricDefinition;
        this.pagerDutyIncidentDetail = builder.pagerDutyIncidentDetail;
        this.url = builder.url;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The metric definition, if the related item is a metric in Amazon CloudWatch.
     * </p>
     * 
     * @return The metric definition, if the related item is a metric in Amazon CloudWatch.
     */
    public final String metricDefinition() {
        return metricDefinition;
    }

    /**
     * <p>
     * Details about an incident that is associated with a PagerDuty incident.
     * </p>
     * 
     * @return Details about an incident that is associated with a PagerDuty incident.
     */
    public final PagerDutyIncidentDetail pagerDutyIncidentDetail() {
        return pagerDutyIncidentDetail;
    }

    /**
     * <p>
     * The URL, if the related item is a non-Amazon Web Services resource.
     * </p>
     * 
     * @return The URL, if the related item is a non-Amazon Web Services resource.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(pagerDutyIncidentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemValue)) {
            return false;
        }
        ItemValue other = (ItemValue) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(metricDefinition(), other.metricDefinition())
                && Objects.equals(pagerDutyIncidentDetail(), other.pagerDutyIncidentDetail())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemValue").add("Arn", arn()).add("MetricDefinition", metricDefinition())
                .add("PagerDutyIncidentDetail", pagerDutyIncidentDetail()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "metricDefinition":
            return Optional.ofNullable(clazz.cast(metricDefinition()));
        case "pagerDutyIncidentDetail":
            return Optional.ofNullable(clazz.cast(pagerDutyIncidentDetail()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #arn()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
     */
    public static ItemValue fromArn(String arn) {
        return builder().arn(arn).build();
    }

    /**
     * Create an instance of this class with {@link #metricDefinition()} initialized to the given value.
     *
     * <p>
     * The metric definition, if the related item is a metric in Amazon CloudWatch.
     * </p>
     * 
     * @param metricDefinition
     *        The metric definition, if the related item is a metric in Amazon CloudWatch.
     */
    public static ItemValue fromMetricDefinition(String metricDefinition) {
        return builder().metricDefinition(metricDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #pagerDutyIncidentDetail()} initialized to the given value.
     *
     * <p>
     * Details about an incident that is associated with a PagerDuty incident.
     * </p>
     * 
     * @param pagerDutyIncidentDetail
     *        Details about an incident that is associated with a PagerDuty incident.
     */
    public static ItemValue fromPagerDutyIncidentDetail(PagerDutyIncidentDetail pagerDutyIncidentDetail) {
        return builder().pagerDutyIncidentDetail(pagerDutyIncidentDetail).build();
    }

    /**
     * Create an instance of this class with {@link #pagerDutyIncidentDetail()} initialized to the given value.
     *
     * <p>
     * Details about an incident that is associated with a PagerDuty incident.
     * </p>
     * 
     * @param pagerDutyIncidentDetail
     *        Details about an incident that is associated with a PagerDuty incident.
     */
    public static ItemValue fromPagerDutyIncidentDetail(Consumer<PagerDutyIncidentDetail.Builder> pagerDutyIncidentDetail) {
        PagerDutyIncidentDetail.Builder builder = PagerDutyIncidentDetail.builder();
        pagerDutyIncidentDetail.accept(builder);
        return fromPagerDutyIncidentDetail(builder.build());
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * The URL, if the related item is a non-Amazon Web Services resource.
     * </p>
     * 
     * @param url
     *        The URL, if the related item is a non-Amazon Web Services resource.
     */
    public static ItemValue fromUrl(String url) {
        return builder().url(url).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ItemValue, T> g) {
        return obj -> g.apply((ItemValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemValue> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The metric definition, if the related item is a metric in Amazon CloudWatch.
         * </p>
         * 
         * @param metricDefinition
         *        The metric definition, if the related item is a metric in Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinition(String metricDefinition);

        /**
         * <p>
         * Details about an incident that is associated with a PagerDuty incident.
         * </p>
         * 
         * @param pagerDutyIncidentDetail
         *        Details about an incident that is associated with a PagerDuty incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pagerDutyIncidentDetail(PagerDutyIncidentDetail pagerDutyIncidentDetail);

        /**
         * <p>
         * Details about an incident that is associated with a PagerDuty incident.
         * </p>
         * This is a convenience method that creates an instance of the {@link PagerDutyIncidentDetail.Builder} avoiding
         * the need to create one manually via {@link PagerDutyIncidentDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PagerDutyIncidentDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #pagerDutyIncidentDetail(PagerDutyIncidentDetail)}.
         * 
         * @param pagerDutyIncidentDetail
         *        a consumer that will call methods on {@link PagerDutyIncidentDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pagerDutyIncidentDetail(PagerDutyIncidentDetail)
         */
        default Builder pagerDutyIncidentDetail(Consumer<PagerDutyIncidentDetail.Builder> pagerDutyIncidentDetail) {
            return pagerDutyIncidentDetail(PagerDutyIncidentDetail.builder().applyMutation(pagerDutyIncidentDetail).build());
        }

        /**
         * <p>
         * The URL, if the related item is a non-Amazon Web Services resource.
         * </p>
         * 
         * @param url
         *        The URL, if the related item is a non-Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String metricDefinition;

        private PagerDutyIncidentDetail pagerDutyIncidentDetail;

        private String url;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ItemValue model) {
            arn(model.arn);
            metricDefinition(model.metricDefinition);
            pagerDutyIncidentDetail(model.pagerDutyIncidentDetail);
            url(model.url);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            Object oldValue = this.arn;
            this.arn = arn;
            handleUnionValueChange(Type.ARN, oldValue, this.arn);
        }

        @Override
        public final Builder arn(String arn) {
            Object oldValue = this.arn;
            this.arn = arn;
            handleUnionValueChange(Type.ARN, oldValue, this.arn);
            return this;
        }

        public final String getMetricDefinition() {
            return metricDefinition;
        }

        public final void setMetricDefinition(String metricDefinition) {
            Object oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
        }

        @Override
        public final Builder metricDefinition(String metricDefinition) {
            Object oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
            return this;
        }

        public final PagerDutyIncidentDetail.Builder getPagerDutyIncidentDetail() {
            return pagerDutyIncidentDetail != null ? pagerDutyIncidentDetail.toBuilder() : null;
        }

        public final void setPagerDutyIncidentDetail(PagerDutyIncidentDetail.BuilderImpl pagerDutyIncidentDetail) {
            Object oldValue = this.pagerDutyIncidentDetail;
            this.pagerDutyIncidentDetail = pagerDutyIncidentDetail != null ? pagerDutyIncidentDetail.build() : null;
            handleUnionValueChange(Type.PAGER_DUTY_INCIDENT_DETAIL, oldValue, this.pagerDutyIncidentDetail);
        }

        @Override
        public final Builder pagerDutyIncidentDetail(PagerDutyIncidentDetail pagerDutyIncidentDetail) {
            Object oldValue = this.pagerDutyIncidentDetail;
            this.pagerDutyIncidentDetail = pagerDutyIncidentDetail;
            handleUnionValueChange(Type.PAGER_DUTY_INCIDENT_DETAIL, oldValue, this.pagerDutyIncidentDetail);
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(String url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        @Override
        public ItemValue build() {
            return new ItemValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ItemValue#type()
     */
    public enum Type {
        ARN,

        METRIC_DEFINITION,

        PAGER_DUTY_INCIDENT_DETAIL,

        URL,

        UNKNOWN_TO_SDK_VERSION
    }
}
