/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationSetRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<UpdateReplicationSetRequest.Builder, UpdateReplicationSetRequest> {
    private static final SdkField<List<UpdateReplicationSetAction>> ACTIONS_FIELD = SdkField
            .<List<UpdateReplicationSetAction>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(UpdateReplicationSetRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateReplicationSetAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateReplicationSetAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateReplicationSetRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateReplicationSetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, ARN_FIELD,
            CLIENT_TOKEN_FIELD));

    private final List<UpdateReplicationSetAction> actions;

    private final String arn;

    private final String clientToken;

    private UpdateReplicationSetRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An action to add or delete a Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return An action to add or delete a Region.
     */
    public final List<UpdateReplicationSetAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication set you're updating.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication set you're updating.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A token that ensures that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token that ensures that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationSetRequest)) {
            return false;
        }
        UpdateReplicationSetRequest other = (UpdateReplicationSetRequest) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(arn(), other.arn()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReplicationSetRequest").add("Actions", hasActions() ? actions() : null).add("Arn", arn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationSetRequest, T> g) {
        return obj -> g.apply((UpdateReplicationSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReplicationSetRequest> {
        /**
         * <p>
         * An action to add or delete a Region.
         * </p>
         * 
         * @param actions
         *        An action to add or delete a Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<UpdateReplicationSetAction> actions);

        /**
         * <p>
         * An action to add or delete a Region.
         * </p>
         * 
         * @param actions
         *        An action to add or delete a Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(UpdateReplicationSetAction... actions);

        /**
         * <p>
         * An action to add or delete a Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetAction.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetAction.Builder#build()} is
         * called immediately and its result is passed to {@link #actions(List<UpdateReplicationSetAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<UpdateReplicationSetAction>)
         */
        Builder actions(Consumer<UpdateReplicationSetAction.Builder>... actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication set you're updating.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the replication set you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A token that ensures that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private List<UpdateReplicationSetAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationSetRequest model) {
            super(model);
            actions(model.actions);
            arn(model.arn);
            clientToken(model.clientToken);
        }

        public final List<UpdateReplicationSetAction.Builder> getActions() {
            List<UpdateReplicationSetAction.Builder> result = UpdateReplicationSetInputActionsListCopier
                    .copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<UpdateReplicationSetAction.BuilderImpl> actions) {
            this.actions = UpdateReplicationSetInputActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<UpdateReplicationSetAction> actions) {
            this.actions = UpdateReplicationSetInputActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(UpdateReplicationSetAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<UpdateReplicationSetAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> UpdateReplicationSetAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationSetRequest build() {
            return new UpdateReplicationSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
