/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterApplicationRequest extends SsmSapRequest implements
        ToCopyableBuilder<RegisterApplicationRequest.Builder, RegisterApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(RegisterApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationType").getter(getter(RegisterApplicationRequest::applicationTypeAsString))
            .setter(setter(Builder::applicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationType").build()).build();

    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(RegisterApplicationRequest::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SAP_INSTANCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SapInstanceNumber").getter(getter(RegisterApplicationRequest::sapInstanceNumber))
            .setter(setter(Builder::sapInstanceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SapInstanceNumber").build()).build();

    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sid")
            .getter(getter(RegisterApplicationRequest::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sid").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RegisterApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_FIELD = SdkField
            .<List<ApplicationCredential>> builder(MarshallingType.LIST)
            .memberName("Credentials")
            .getter(getter(RegisterApplicationRequest::credentials))
            .setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationCredential> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationCredential::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_TYPE_FIELD, INSTANCES_FIELD, SAP_INSTANCE_NUMBER_FIELD, SID_FIELD, TAGS_FIELD, CREDENTIALS_FIELD));

    private final String applicationId;

    private final String applicationType;

    private final List<String> instances;

    private final String sapInstanceNumber;

    private final String sid;

    private final Map<String, String> tags;

    private final List<ApplicationCredential> credentials;

    private RegisterApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationType = builder.applicationType;
        this.instances = builder.instances;
        this.sapInstanceNumber = builder.sapInstanceNumber;
        this.sid = builder.sid;
        this.tags = builder.tags;
        this.credentials = builder.credentials;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationType}
     * will return {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationTypeAsString}.
     * </p>
     * 
     * @return
     * @see ApplicationType
     */
    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(applicationType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationType}
     * will return {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationTypeAsString}.
     * </p>
     * 
     * @return
     * @see ApplicationType
     */
    public final String applicationTypeAsString() {
        return applicationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return
     */
    public final List<String> instances() {
        return instances;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String sapInstanceNumber() {
        return sapInstanceNumber;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String sid() {
        return sid;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Credentials property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentials() {
        return credentials != null && !(credentials instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentials} method.
     * </p>
     * 
     * @return
     */
    public final List<ApplicationCredential> credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sapInstanceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentials() ? credentials() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationRequest)) {
            return false;
        }
        RegisterApplicationRequest other = (RegisterApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationTypeAsString(), other.applicationTypeAsString())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(sapInstanceNumber(), other.sapInstanceNumber()) && Objects.equals(sid(), other.sid())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasCredentials() == other.hasCredentials() && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterApplicationRequest").add("ApplicationId", applicationId())
                .add("ApplicationType", applicationTypeAsString()).add("Instances", hasInstances() ? instances() : null)
                .add("SapInstanceNumber", sapInstanceNumber()).add("Sid", sid()).add("Tags", hasTags() ? tags() : null)
                .add("Credentials", hasCredentials() ? credentials() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ApplicationType":
            return Optional.ofNullable(clazz.cast(applicationTypeAsString()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "SapInstanceNumber":
            return Optional.ofNullable(clazz.cast(sapInstanceNumber()));
        case "Sid":
            return Optional.ofNullable(clazz.cast(sid()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterApplicationRequest, T> g) {
        return obj -> g.apply((RegisterApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterApplicationRequest> {
        /**
         * <p/>
         * 
         * @param applicationId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p/>
         * 
         * @param applicationType
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder applicationType(String applicationType);

        /**
         * <p/>
         * 
         * @param applicationType
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder applicationType(ApplicationType applicationType);

        /**
         * <p/>
         * 
         * @param instances
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p/>
         * 
         * @param instances
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p/>
         * 
         * @param sapInstanceNumber
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sapInstanceNumber(String sapInstanceNumber);

        /**
         * <p/>
         * 
         * @param sid
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);

        /**
         * <p/>
         * 
         * @param tags
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p/>
         * 
         * @param credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Collection<ApplicationCredential> credentials);

        /**
         * <p/>
         * 
         * @param credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(ApplicationCredential... credentials);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder#build()} is called
         * immediately and its result is passed to {@link #credentials(List<ApplicationCredential>)}.
         * 
         * @param credentials
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(java.util.Collection<ApplicationCredential>)
         */
        Builder credentials(Consumer<ApplicationCredential.Builder>... credentials);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String applicationType;

        private List<String> instances = DefaultSdkAutoConstructList.getInstance();

        private String sapInstanceNumber;

        private String sid;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<ApplicationCredential> credentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            applicationType(model.applicationType);
            instances(model.instances);
            sapInstanceNumber(model.sapInstanceNumber);
            sid(model.sid);
            tags(model.tags);
            credentials(model.credentials);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationType() {
            return applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final Collection<String> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final String getSapInstanceNumber() {
            return sapInstanceNumber;
        }

        public final void setSapInstanceNumber(String sapInstanceNumber) {
            this.sapInstanceNumber = sapInstanceNumber;
        }

        @Override
        public final Builder sapInstanceNumber(String sapInstanceNumber) {
            this.sapInstanceNumber = sapInstanceNumber;
            return this;
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentials() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<ApplicationCredential.BuilderImpl> credentials) {
            this.credentials = ApplicationCredentialListCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<ApplicationCredential> credentials) {
            this.credentials = ApplicationCredentialListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(ApplicationCredential... credentials) {
            credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<ApplicationCredential.Builder>... credentials) {
            credentials(Stream.of(credentials).map(c -> ApplicationCredential.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterApplicationRequest build() {
            return new RegisterApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
