/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An SAP application registered with AWS Systems Manager for SAP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Application::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Application::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Application::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> APP_REGISTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppRegistryArn").getter(getter(Application::appRegistryArn)).setter(setter(Builder::appRegistryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppRegistryArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Application::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DISCOVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryStatus").getter(getter(Application::discoveryStatusAsString))
            .setter(setter(Builder::discoveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryStatus").build()).build();

    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Components")
            .getter(getter(Application::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(Application::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(Application::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            ARN_FIELD, APP_REGISTRY_ARN_FIELD, STATUS_FIELD, DISCOVERY_STATUS_FIELD, COMPONENTS_FIELD, LAST_UPDATED_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String arn;

    private final String appRegistryArn;

    private final String status;

    private final String discoveryStatus;

    private final List<String> components;

    private final Instant lastUpdated;

    private final String statusMessage;

    private Application(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.arn = builder.arn;
        this.appRegistryArn = builder.appRegistryArn;
        this.status = builder.status;
        this.discoveryStatus = builder.discoveryStatus;
        this.components = builder.components;
        this.lastUpdated = builder.lastUpdated;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the application.
     * @see ApplicationType
     */
    public final ApplicationType type() {
        return ApplicationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the application.
     * @see ApplicationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Application Registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Application Registry.
     */
    public final String appRegistryArn() {
        return appRegistryArn;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The latest discovery result for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryStatus}
     * will return {@link ApplicationDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discoveryStatusAsString}.
     * </p>
     * 
     * @return The latest discovery result for the application.
     * @see ApplicationDiscoveryStatus
     */
    public final ApplicationDiscoveryStatus discoveryStatus() {
        return ApplicationDiscoveryStatus.fromValue(discoveryStatus);
    }

    /**
     * <p>
     * The latest discovery result for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryStatus}
     * will return {@link ApplicationDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discoveryStatusAsString}.
     * </p>
     * 
     * @return The latest discovery result for the application.
     * @see ApplicationDiscoveryStatus
     */
    public final String discoveryStatusAsString() {
        return discoveryStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components of the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return The components of the application.
     */
    public final List<String> components() {
        return components;
    }

    /**
     * <p>
     * The time at which the application was last updated.
     * </p>
     * 
     * @return The time at which the application was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(appRegistryArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(appRegistryArn(), other.appRegistryArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(discoveryStatusAsString(), other.discoveryStatusAsString())
                && hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Application").add("Id", id()).add("Type", typeAsString()).add("Arn", arn())
                .add("AppRegistryArn", appRegistryArn()).add("Status", statusAsString())
                .add("DiscoveryStatus", discoveryStatusAsString()).add("Components", hasComponents() ? components() : null)
                .add("LastUpdated", lastUpdated()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AppRegistryArn":
            return Optional.ofNullable(clazz.cast(appRegistryArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DiscoveryStatus":
            return Optional.ofNullable(clazz.cast(discoveryStatusAsString()));
        case "Components":
            return Optional.ofNullable(clazz.cast(components()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param id
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the application.
         * </p>
         * 
         * @param type
         *        The type of the application.
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the application.
         * </p>
         * 
         * @param type
         *        The type of the application.
         * @see ApplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationType
         */
        Builder type(ApplicationType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Application Registry.
         * </p>
         * 
         * @param appRegistryArn
         *        The Amazon Resource Name (ARN) of the Application Registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appRegistryArn(String appRegistryArn);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * The latest discovery result for the application.
         * </p>
         * 
         * @param discoveryStatus
         *        The latest discovery result for the application.
         * @see ApplicationDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDiscoveryStatus
         */
        Builder discoveryStatus(String discoveryStatus);

        /**
         * <p>
         * The latest discovery result for the application.
         * </p>
         * 
         * @param discoveryStatus
         *        The latest discovery result for the application.
         * @see ApplicationDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDiscoveryStatus
         */
        Builder discoveryStatus(ApplicationDiscoveryStatus discoveryStatus);

        /**
         * <p>
         * The components of the application.
         * </p>
         * 
         * @param components
         *        The components of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<String> components);

        /**
         * <p>
         * The components of the application.
         * </p>
         * 
         * @param components
         *        The components of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(String... components);

        /**
         * <p>
         * The time at which the application was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time at which the application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String arn;

        private String appRegistryArn;

        private String status;

        private String discoveryStatus;

        private List<String> components = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdated;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            id(model.id);
            type(model.type);
            arn(model.arn);
            appRegistryArn(model.appRegistryArn);
            status(model.status);
            discoveryStatus(model.discoveryStatus);
            components(model.components);
            lastUpdated(model.lastUpdated);
            statusMessage(model.statusMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApplicationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAppRegistryArn() {
            return appRegistryArn;
        }

        public final void setAppRegistryArn(String appRegistryArn) {
            this.appRegistryArn = appRegistryArn;
        }

        @Override
        public final Builder appRegistryArn(String appRegistryArn) {
            this.appRegistryArn = appRegistryArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDiscoveryStatus() {
            return discoveryStatus;
        }

        public final void setDiscoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
        }

        @Override
        public final Builder discoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
            return this;
        }

        @Override
        public final Builder discoveryStatus(ApplicationDiscoveryStatus discoveryStatus) {
            this.discoveryStatus(discoveryStatus == null ? null : discoveryStatus.toString());
            return this;
        }

        public final Collection<String> getComponents() {
            if (components instanceof SdkAutoConstructList) {
                return null;
            }
            return components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = ComponentIdListCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = ComponentIdListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String... components) {
            components(Arrays.asList(components));
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
