/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationSettingsRequest extends SsmSapRequest implements
        ToCopyableBuilder<UpdateApplicationSettingsRequest.Builder, UpdateApplicationSettingsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateApplicationSettingsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_TO_ADD_OR_UPDATE_FIELD = SdkField
            .<List<ApplicationCredential>> builder(MarshallingType.LIST)
            .memberName("CredentialsToAddOrUpdate")
            .getter(getter(UpdateApplicationSettingsRequest::credentialsToAddOrUpdate))
            .setter(setter(Builder::credentialsToAddOrUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsToAddOrUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationCredential> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationCredential::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_TO_REMOVE_FIELD = SdkField
            .<List<ApplicationCredential>> builder(MarshallingType.LIST)
            .memberName("CredentialsToRemove")
            .getter(getter(UpdateApplicationSettingsRequest::credentialsToRemove))
            .setter(setter(Builder::credentialsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationCredential> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationCredential::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BackintConfig> BACKINT_FIELD = SdkField.<BackintConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Backint").getter(getter(UpdateApplicationSettingsRequest::backint)).setter(setter(Builder::backint))
            .constructor(BackintConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backint").build()).build();

    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseArn").getter(getter(UpdateApplicationSettingsRequest::databaseArn))
            .setter(setter(Builder::databaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREDENTIALS_TO_ADD_OR_UPDATE_FIELD, CREDENTIALS_TO_REMOVE_FIELD, BACKINT_FIELD, DATABASE_ARN_FIELD));

    private final String applicationId;

    private final List<ApplicationCredential> credentialsToAddOrUpdate;

    private final List<ApplicationCredential> credentialsToRemove;

    private final BackintConfig backint;

    private final String databaseArn;

    private UpdateApplicationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.credentialsToAddOrUpdate = builder.credentialsToAddOrUpdate;
        this.credentialsToRemove = builder.credentialsToRemove;
        this.backint = builder.backint;
        this.databaseArn = builder.databaseArn;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CredentialsToAddOrUpdate property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCredentialsToAddOrUpdate() {
        return credentialsToAddOrUpdate != null && !(credentialsToAddOrUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The credentials to be added or updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentialsToAddOrUpdate} method.
     * </p>
     * 
     * @return The credentials to be added or updated.
     */
    public final List<ApplicationCredential> credentialsToAddOrUpdate() {
        return credentialsToAddOrUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CredentialsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentialsToRemove() {
        return credentialsToRemove != null && !(credentialsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The credentials to be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentialsToRemove} method.
     * </p>
     * 
     * @return The credentials to be removed.
     */
    public final List<ApplicationCredential> credentialsToRemove() {
        return credentialsToRemove;
    }

    /**
     * <p>
     * Installation of AWS Backint Agent for SAP HANA.
     * </p>
     * 
     * @return Installation of AWS Backint Agent for SAP HANA.
     */
    public final BackintConfig backint() {
        return backint;
    }

    /**
     * <p>
     * The Amazon Resource Name of the SAP HANA database that replaces the current SAP HANA connection with the SAP_ABAP
     * application.
     * </p>
     * 
     * @return The Amazon Resource Name of the SAP HANA database that replaces the current SAP HANA connection with the
     *         SAP_ABAP application.
     */
    public final String databaseArn() {
        return databaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentialsToAddOrUpdate() ? credentialsToAddOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentialsToRemove() ? credentialsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backint());
        hashCode = 31 * hashCode + Objects.hashCode(databaseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsRequest)) {
            return false;
        }
        UpdateApplicationSettingsRequest other = (UpdateApplicationSettingsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && hasCredentialsToAddOrUpdate() == other.hasCredentialsToAddOrUpdate()
                && Objects.equals(credentialsToAddOrUpdate(), other.credentialsToAddOrUpdate())
                && hasCredentialsToRemove() == other.hasCredentialsToRemove()
                && Objects.equals(credentialsToRemove(), other.credentialsToRemove())
                && Objects.equals(backint(), other.backint()) && Objects.equals(databaseArn(), other.databaseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationSettingsRequest").add("ApplicationId", applicationId())
                .add("CredentialsToAddOrUpdate", hasCredentialsToAddOrUpdate() ? credentialsToAddOrUpdate() : null)
                .add("CredentialsToRemove", hasCredentialsToRemove() ? credentialsToRemove() : null).add("Backint", backint())
                .add("DatabaseArn", databaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CredentialsToAddOrUpdate":
            return Optional.ofNullable(clazz.cast(credentialsToAddOrUpdate()));
        case "CredentialsToRemove":
            return Optional.ofNullable(clazz.cast(credentialsToRemove()));
        case "Backint":
            return Optional.ofNullable(clazz.cast(backint()));
        case "DatabaseArn":
            return Optional.ofNullable(clazz.cast(databaseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationSettingsRequest, T> g) {
        return obj -> g.apply((UpdateApplicationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmSapRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The credentials to be added or updated.
         * </p>
         * 
         * @param credentialsToAddOrUpdate
         *        The credentials to be added or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsToAddOrUpdate(Collection<ApplicationCredential> credentialsToAddOrUpdate);

        /**
         * <p>
         * The credentials to be added or updated.
         * </p>
         * 
         * @param credentialsToAddOrUpdate
         *        The credentials to be added or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsToAddOrUpdate(ApplicationCredential... credentialsToAddOrUpdate);

        /**
         * <p>
         * The credentials to be added or updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder#build()} is called
         * immediately and its result is passed to {@link #credentialsToAddOrUpdate(List<ApplicationCredential>)}.
         * 
         * @param credentialsToAddOrUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialsToAddOrUpdate(java.util.Collection<ApplicationCredential>)
         */
        Builder credentialsToAddOrUpdate(Consumer<ApplicationCredential.Builder>... credentialsToAddOrUpdate);

        /**
         * <p>
         * The credentials to be removed.
         * </p>
         * 
         * @param credentialsToRemove
         *        The credentials to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsToRemove(Collection<ApplicationCredential> credentialsToRemove);

        /**
         * <p>
         * The credentials to be removed.
         * </p>
         * 
         * @param credentialsToRemove
         *        The credentials to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsToRemove(ApplicationCredential... credentialsToRemove);

        /**
         * <p>
         * The credentials to be removed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder#build()} is called
         * immediately and its result is passed to {@link #credentialsToRemove(List<ApplicationCredential>)}.
         * 
         * @param credentialsToRemove
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmsap.model.ApplicationCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialsToRemove(java.util.Collection<ApplicationCredential>)
         */
        Builder credentialsToRemove(Consumer<ApplicationCredential.Builder>... credentialsToRemove);

        /**
         * <p>
         * Installation of AWS Backint Agent for SAP HANA.
         * </p>
         * 
         * @param backint
         *        Installation of AWS Backint Agent for SAP HANA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backint(BackintConfig backint);

        /**
         * <p>
         * Installation of AWS Backint Agent for SAP HANA.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackintConfig.Builder} avoiding the need
         * to create one manually via {@link BackintConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackintConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #backint(BackintConfig)}.
         * 
         * @param backint
         *        a consumer that will call methods on {@link BackintConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backint(BackintConfig)
         */
        default Builder backint(Consumer<BackintConfig.Builder> backint) {
            return backint(BackintConfig.builder().applyMutation(backint).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the SAP HANA database that replaces the current SAP HANA connection with the
         * SAP_ABAP application.
         * </p>
         * 
         * @param databaseArn
         *        The Amazon Resource Name of the SAP HANA database that replaces the current SAP HANA connection with
         *        the SAP_ABAP application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseArn(String databaseArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmSapRequest.BuilderImpl implements Builder {
        private String applicationId;

        private List<ApplicationCredential> credentialsToAddOrUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<ApplicationCredential> credentialsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BackintConfig backint;

        private String databaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsRequest model) {
            super(model);
            applicationId(model.applicationId);
            credentialsToAddOrUpdate(model.credentialsToAddOrUpdate);
            credentialsToRemove(model.credentialsToRemove);
            backint(model.backint);
            databaseArn(model.databaseArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentialsToAddOrUpdate() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier
                    .copyToBuilder(this.credentialsToAddOrUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialsToAddOrUpdate(Collection<ApplicationCredential.BuilderImpl> credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate = ApplicationCredentialListCopier.copyFromBuilder(credentialsToAddOrUpdate);
        }

        @Override
        public final Builder credentialsToAddOrUpdate(Collection<ApplicationCredential> credentialsToAddOrUpdate) {
            this.credentialsToAddOrUpdate = ApplicationCredentialListCopier.copy(credentialsToAddOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToAddOrUpdate(ApplicationCredential... credentialsToAddOrUpdate) {
            credentialsToAddOrUpdate(Arrays.asList(credentialsToAddOrUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToAddOrUpdate(Consumer<ApplicationCredential.Builder>... credentialsToAddOrUpdate) {
            credentialsToAddOrUpdate(Stream.of(credentialsToAddOrUpdate)
                    .map(c -> ApplicationCredential.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentialsToRemove() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentialsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialsToRemove(Collection<ApplicationCredential.BuilderImpl> credentialsToRemove) {
            this.credentialsToRemove = ApplicationCredentialListCopier.copyFromBuilder(credentialsToRemove);
        }

        @Override
        public final Builder credentialsToRemove(Collection<ApplicationCredential> credentialsToRemove) {
            this.credentialsToRemove = ApplicationCredentialListCopier.copy(credentialsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToRemove(ApplicationCredential... credentialsToRemove) {
            credentialsToRemove(Arrays.asList(credentialsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialsToRemove(Consumer<ApplicationCredential.Builder>... credentialsToRemove) {
            credentialsToRemove(Stream.of(credentialsToRemove).map(c -> ApplicationCredential.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final BackintConfig.Builder getBackint() {
            return backint != null ? backint.toBuilder() : null;
        }

        public final void setBackint(BackintConfig.BuilderImpl backint) {
            this.backint = backint != null ? backint.build() : null;
        }

        @Override
        public final Builder backint(BackintConfig backint) {
            this.backint = backint;
            return this;
        }

        public final String getDatabaseArn() {
            return databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationSettingsRequest build() {
            return new UpdateApplicationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
