/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TrustedTokenIssuerListCopier {
    static List<TrustedTokenIssuerMetadata> copy(Collection<? extends TrustedTokenIssuerMetadata> trustedTokenIssuerListParam) {
        List<TrustedTokenIssuerMetadata> list;
        if (trustedTokenIssuerListParam == null || trustedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedTokenIssuerMetadata> modifiableList = new ArrayList<>();
            trustedTokenIssuerListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TrustedTokenIssuerMetadata> copyFromBuilder(
            Collection<? extends TrustedTokenIssuerMetadata.Builder> trustedTokenIssuerListParam) {
        List<TrustedTokenIssuerMetadata> list;
        if (trustedTokenIssuerListParam == null || trustedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedTokenIssuerMetadata> modifiableList = new ArrayList<>();
            trustedTokenIssuerListParam.forEach(entry -> {
                TrustedTokenIssuerMetadata member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TrustedTokenIssuerMetadata.Builder> copyToBuilder(
            Collection<? extends TrustedTokenIssuerMetadata> trustedTokenIssuerListParam) {
        List<TrustedTokenIssuerMetadata.Builder> list;
        if (trustedTokenIssuerListParam == null || trustedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TrustedTokenIssuerMetadata.Builder> modifiableList = new ArrayList<>();
            trustedTokenIssuerListParam.forEach(entry -> {
                TrustedTokenIssuerMetadata.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
