/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes an authentication method and its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationMethodItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationMethodItem.Builder, AuthenticationMethodItem> {
    private static final SdkField<AuthenticationMethod> AUTHENTICATION_METHOD_FIELD = SdkField
            .<AuthenticationMethod> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMethod")
            .getter(getter(AuthenticationMethodItem::authenticationMethod)).setter(setter(Builder::authenticationMethod))
            .constructor(AuthenticationMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_METHOD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMethodType").getter(getter(AuthenticationMethodItem::authenticationMethodTypeAsString))
            .setter(setter(Builder::authenticationMethodType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethodType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_METHOD_FIELD,
            AUTHENTICATION_METHOD_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AuthenticationMethod authenticationMethod;

    private final String authenticationMethodType;

    private AuthenticationMethodItem(BuilderImpl builder) {
        this.authenticationMethod = builder.authenticationMethod;
        this.authenticationMethodType = builder.authenticationMethodType;
    }

    /**
     * <p>
     * A structure that describes an authentication method. The contents of this structure is determined by the
     * <code>AuthenticationMethodType</code>.
     * </p>
     * 
     * @return A structure that describes an authentication method. The contents of this structure is determined by the
     *         <code>AuthenticationMethodType</code>.
     */
    public final AuthenticationMethod authenticationMethod() {
        return authenticationMethod;
    }

    /**
     * <p>
     * The type of authentication that is used by this method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethodType} will return {@link AuthenticationMethodType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that is used by this method.
     * @see AuthenticationMethodType
     */
    public final AuthenticationMethodType authenticationMethodType() {
        return AuthenticationMethodType.fromValue(authenticationMethodType);
    }

    /**
     * <p>
     * The type of authentication that is used by this method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethodType} will return {@link AuthenticationMethodType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that is used by this method.
     * @see AuthenticationMethodType
     */
    public final String authenticationMethodTypeAsString() {
        return authenticationMethodType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMethodItem)) {
            return false;
        }
        AuthenticationMethodItem other = (AuthenticationMethodItem) obj;
        return Objects.equals(authenticationMethod(), other.authenticationMethod())
                && Objects.equals(authenticationMethodTypeAsString(), other.authenticationMethodTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationMethodItem").add("AuthenticationMethod", authenticationMethod())
                .add("AuthenticationMethodType", authenticationMethodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethod()));
        case "AuthenticationMethodType":
            return Optional.ofNullable(clazz.cast(authenticationMethodTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMethodItem, T> g) {
        return obj -> g.apply((AuthenticationMethodItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationMethodItem> {
        /**
         * <p>
         * A structure that describes an authentication method. The contents of this structure is determined by the
         * <code>AuthenticationMethodType</code>.
         * </p>
         * 
         * @param authenticationMethod
         *        A structure that describes an authentication method. The contents of this structure is determined by
         *        the <code>AuthenticationMethodType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMethod(AuthenticationMethod authenticationMethod);

        /**
         * <p>
         * A structure that describes an authentication method. The contents of this structure is determined by the
         * <code>AuthenticationMethodType</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMethod.Builder} avoiding
         * the need to create one manually via {@link AuthenticationMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationMethod.Builder#build()} is called immediately and
         * its result is passed to {@link #authenticationMethod(AuthenticationMethod)}.
         * 
         * @param authenticationMethod
         *        a consumer that will call methods on {@link AuthenticationMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMethod(AuthenticationMethod)
         */
        default Builder authenticationMethod(Consumer<AuthenticationMethod.Builder> authenticationMethod) {
            return authenticationMethod(AuthenticationMethod.builder().applyMutation(authenticationMethod).build());
        }

        /**
         * <p>
         * The type of authentication that is used by this method.
         * </p>
         * 
         * @param authenticationMethodType
         *        The type of authentication that is used by this method.
         * @see AuthenticationMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodType
         */
        Builder authenticationMethodType(String authenticationMethodType);

        /**
         * <p>
         * The type of authentication that is used by this method.
         * </p>
         * 
         * @param authenticationMethodType
         *        The type of authentication that is used by this method.
         * @see AuthenticationMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodType
         */
        Builder authenticationMethodType(AuthenticationMethodType authenticationMethodType);
    }

    static final class BuilderImpl implements Builder {
        private AuthenticationMethod authenticationMethod;

        private String authenticationMethodType;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMethodItem model) {
            authenticationMethod(model.authenticationMethod);
            authenticationMethodType(model.authenticationMethodType);
        }

        public final AuthenticationMethod.Builder getAuthenticationMethod() {
            return authenticationMethod != null ? authenticationMethod.toBuilder() : null;
        }

        public final void setAuthenticationMethod(AuthenticationMethod.BuilderImpl authenticationMethod) {
            this.authenticationMethod = authenticationMethod != null ? authenticationMethod.build() : null;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public final String getAuthenticationMethodType() {
            return authenticationMethodType;
        }

        public final void setAuthenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
        }

        @Override
        public final Builder authenticationMethodType(String authenticationMethodType) {
            this.authenticationMethodType = authenticationMethodType;
            return this;
        }

        @Override
        public final Builder authenticationMethodType(AuthenticationMethodType authenticationMethodType) {
            this.authenticationMethodType(authenticationMethodType == null ? null : authenticationMethodType.toString());
            return this;
        }

        @Override
        public AuthenticationMethodItem build() {
            return new AuthenticationMethodItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
