/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the summary returned by <code>ListFileSystemAssociation</code>, which is a summary of a created file system
 * association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemAssociationSummary.Builder, FileSystemAssociationSummary> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationId").getter(getter(FileSystemAssociationSummary::fileSystemAssociationId))
            .setter(setter(Builder::fileSystemAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationId").build())
            .build();

    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationARN").getter(getter(FileSystemAssociationSummary::fileSystemAssociationARN))
            .setter(setter(Builder::fileSystemAssociationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build())
            .build();

    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationStatus")
            .getter(getter(FileSystemAssociationSummary::fileSystemAssociationStatus))
            .setter(setter(Builder::fileSystemAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationStatus")
                    .build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(FileSystemAssociationSummary::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_SYSTEM_ASSOCIATION_ID_FIELD, FILE_SYSTEM_ASSOCIATION_ARN_FIELD, FILE_SYSTEM_ASSOCIATION_STATUS_FIELD,
            GATEWAY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemAssociationId;

    private final String fileSystemAssociationARN;

    private final String fileSystemAssociationStatus;

    private final String gatewayARN;

    private FileSystemAssociationSummary(BuilderImpl builder) {
        this.fileSystemAssociationId = builder.fileSystemAssociationId;
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.fileSystemAssociationStatus = builder.fileSystemAssociationStatus;
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * <p>
     * The ID of the file system association.
     * </p>
     * 
     * @return The ID of the file system association.
     */
    public final String fileSystemAssociationId() {
        return fileSystemAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file system association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file system association.
     */
    public final String fileSystemAssociationARN() {
        return fileSystemAssociationARN;
    }

    /**
     * <p>
     * The status of the file share. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
     * <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
     * </p>
     * 
     * @return The status of the file share. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
     *         <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
     */
    public final String fileSystemAssociationStatus() {
        return fileSystemAssociationStatus;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemAssociationSummary)) {
            return false;
        }
        FileSystemAssociationSummary other = (FileSystemAssociationSummary) obj;
        return Objects.equals(fileSystemAssociationId(), other.fileSystemAssociationId())
                && Objects.equals(fileSystemAssociationARN(), other.fileSystemAssociationARN())
                && Objects.equals(fileSystemAssociationStatus(), other.fileSystemAssociationStatus())
                && Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSystemAssociationSummary").add("FileSystemAssociationId", fileSystemAssociationId())
                .add("FileSystemAssociationARN", fileSystemAssociationARN())
                .add("FileSystemAssociationStatus", fileSystemAssociationStatus()).add("GatewayARN", gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationId":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationId()));
        case "FileSystemAssociationARN":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationARN()));
        case "FileSystemAssociationStatus":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationStatus()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemAssociationSummary, T> g) {
        return obj -> g.apply((FileSystemAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemAssociationSummary> {
        /**
         * <p>
         * The ID of the file system association.
         * </p>
         * 
         * @param fileSystemAssociationId
         *        The ID of the file system association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationId(String fileSystemAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file system association.
         * </p>
         * 
         * @param fileSystemAssociationARN
         *        The Amazon Resource Name (ARN) of the file system association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationARN(String fileSystemAssociationARN);

        /**
         * <p>
         * The status of the file share. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
         * <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
         * </p>
         * 
         * @param fileSystemAssociationStatus
         *        The status of the file share. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
         *        <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationStatus(String fileSystemAssociationStatus);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemAssociationId;

        private String fileSystemAssociationARN;

        private String fileSystemAssociationStatus;

        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemAssociationSummary model) {
            fileSystemAssociationId(model.fileSystemAssociationId);
            fileSystemAssociationARN(model.fileSystemAssociationARN);
            fileSystemAssociationStatus(model.fileSystemAssociationStatus);
            gatewayARN(model.gatewayARN);
        }

        public final String getFileSystemAssociationId() {
            return fileSystemAssociationId;
        }

        public final void setFileSystemAssociationId(String fileSystemAssociationId) {
            this.fileSystemAssociationId = fileSystemAssociationId;
        }

        @Override
        public final Builder fileSystemAssociationId(String fileSystemAssociationId) {
            this.fileSystemAssociationId = fileSystemAssociationId;
            return this;
        }

        public final String getFileSystemAssociationARN() {
            return fileSystemAssociationARN;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final String getFileSystemAssociationStatus() {
            return fileSystemAssociationStatus;
        }

        public final void setFileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
        }

        @Override
        public final Builder fileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        @Override
        public FileSystemAssociationSummary build() {
            return new FileSystemAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
