/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon Web Services Support</fullname>
 * <p>
 * The <i>Amazon Web Services Support API Reference</i> is intended for programmers who need detailed information about
 * the Amazon Web Services Support operations and data types. You can use the API to manage your support cases
 * programmatically. The Amazon Web Services Support API uses HTTP methods that return results in JSON format.
 * </p>
 * <note>
 * <ul>
 * <li>
 * <p>
 * You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or
 * Enterprise Support plan, the <code>SubscriptionRequiredException</code> error message appears. For information about
 * changing your support plan, see <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a>.
 * </p>
 * </li>
 * </ul>
 * </note>
 * <p>
 * The Amazon Web Services Support service also exposes a set of <a
 * href="http://aws.amazon.com/premiumsupport/trustedadvisor/">Trusted Advisor</a> features. You can retrieve a list of
 * checks and their descriptions, get check results, specify checks to refresh, and get the refresh status of checks.
 * </p>
 * <p>
 * The following list describes the Amazon Web Services Support case management operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Service names, issue categories, and available severity levels - The <a>DescribeServices</a> and
 * <a>DescribeSeverityLevels</a> operations return Amazon Web Services service names, service codes, service categories,
 * and problem severity levels. You use these values when you call the <a>CreateCase</a> operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * Case creation, case details, and case resolution - The <a>CreateCase</a>, <a>DescribeCases</a>,
 * <a>DescribeAttachment</a>, and <a>ResolveCase</a> operations create Amazon Web Services Support cases, retrieve
 * information about cases, and resolve cases.
 * </p>
 * </li>
 * <li>
 * <p>
 * Case communication - The <a>DescribeCommunications</a>, <a>AddCommunicationToCase</a>, and <a>AddAttachmentsToSet</a>
 * operations retrieve and add communications and attachments to Amazon Web Services Support cases.
 * </p>
 * </li>
 * </ul>
 * <p>
 * The following list describes the operations available from the Amazon Web Services Support service for Trusted
 * Advisor:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DescribeTrustedAdvisorChecks</a> returns the list of checks that run against your Amazon Web Services resources.
 * </p>
 * </li>
 * <li>
 * <p>
 * Using the <code>checkId</code> for a specific check returned by <a>DescribeTrustedAdvisorChecks</a>, you can call
 * <a>DescribeTrustedAdvisorCheckResult</a> to obtain the results for the check that you specified.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeTrustedAdvisorCheckSummaries</a> returns summarized results for one or more Trusted Advisor checks.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>RefreshTrustedAdvisorCheck</a> requests that Trusted Advisor rerun a specified check.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeTrustedAdvisorCheckRefreshStatuses</a> reports the refresh status of one or more checks.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For authentication of requests, Amazon Web Services Support uses <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>.
 * </p>
 * <p>
 * See <a href="https://docs.aws.amazon.com/awssupport/latest/user/Welcome.html">About the Amazon Web Services Support
 * API</a> in the <i>Amazon Web Services Support User Guide</i> for information about how to use this service to create
 * and manage your support cases, and how to call Trusted Advisor for results of checks on your resources.
 * </p>
 */
package software.amazon.awssdk.services.support;