/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The communications returned by the <a>DescribeCommunications</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCommunicationsResponse extends SupportResponse implements
        ToCopyableBuilder<DescribeCommunicationsResponse.Builder, DescribeCommunicationsResponse> {
    private static final SdkField<List<Communication>> COMMUNICATIONS_FIELD = SdkField
            .<List<Communication>> builder(MarshallingType.LIST)
            .memberName("communications")
            .getter(getter(DescribeCommunicationsResponse::communications))
            .setter(setter(Builder::communications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Communication> builder(MarshallingType.SDK_POJO)
                                            .constructor(Communication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeCommunicationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMUNICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Communication> communications;

    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        super(builder);
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Communications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommunications() {
        return communications != null && !(communications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The communications for the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommunications} method.
     * </p>
     * 
     * @return The communications for the case.
     */
    public final List<Communication> communications() {
        return communications;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCommunications() ? communications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse) obj;
        return hasCommunications() == other.hasCommunications() && Objects.equals(communications(), other.communications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCommunicationsResponse")
                .add("Communications", hasCommunications() ? communications() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "communications":
            return Optional.ofNullable(clazz.cast(communications()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCommunicationsResponse, T> g) {
        return obj -> g.apply((DescribeCommunicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        /**
         * <p>
         * The communications for the case.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Collection<Communication> communications);

        /**
         * <p>
         * The communications for the case.
         * </p>
         * 
         * @param communications
         *        The communications for the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communications(Communication... communications);

        /**
         * <p>
         * The communications for the case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.support.model.Communication.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.support.model.Communication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.support.model.Communication.Builder#build()} is called immediately and
         * its result is passed to {@link #communications(List<Communication>)}.
         * 
         * @param communications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.support.model.Communication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #communications(java.util.Collection<Communication>)
         */
        Builder communications(Consumer<Communication.Builder>... communications);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SupportResponse.BuilderImpl implements Builder {
        private List<Communication> communications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            super(model);
            communications(model.communications);
            nextToken(model.nextToken);
        }

        public final List<Communication.Builder> getCommunications() {
            List<Communication.Builder> result = CommunicationListCopier.copyToBuilder(this.communications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommunications(Collection<Communication.BuilderImpl> communications) {
            this.communications = CommunicationListCopier.copyFromBuilder(communications);
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication... communications) {
            communications(Arrays.asList(communications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Consumer<Communication.Builder>... communications) {
            communications(Stream.of(communications).map(c -> Communication.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
