/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.supportapp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSlackChannelConfigurationRequest extends SupportAppRequest implements
        ToCopyableBuilder<UpdateSlackChannelConfigurationRequest.Builder, UpdateSlackChannelConfigurationRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelId").getter(getter(UpdateSlackChannelConfigurationRequest::channelId))
            .setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(UpdateSlackChannelConfigurationRequest::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CHANNEL_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelRoleArn").getter(getter(UpdateSlackChannelConfigurationRequest::channelRoleArn))
            .setter(setter(Builder::channelRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelRoleArn").build()).build();

    private static final SdkField<Boolean> NOTIFY_ON_ADD_CORRESPONDENCE_TO_CASE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("notifyOnAddCorrespondenceToCase")
            .getter(getter(UpdateSlackChannelConfigurationRequest::notifyOnAddCorrespondenceToCase))
            .setter(setter(Builder::notifyOnAddCorrespondenceToCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifyOnAddCorrespondenceToCase")
                    .build()).build();

    private static final SdkField<String> NOTIFY_ON_CASE_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notifyOnCaseSeverity")
            .getter(getter(UpdateSlackChannelConfigurationRequest::notifyOnCaseSeverityAsString))
            .setter(setter(Builder::notifyOnCaseSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifyOnCaseSeverity").build())
            .build();

    private static final SdkField<Boolean> NOTIFY_ON_CREATE_OR_REOPEN_CASE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("notifyOnCreateOrReopenCase")
            .getter(getter(UpdateSlackChannelConfigurationRequest::notifyOnCreateOrReopenCase))
            .setter(setter(Builder::notifyOnCreateOrReopenCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifyOnCreateOrReopenCase").build())
            .build();

    private static final SdkField<Boolean> NOTIFY_ON_RESOLVE_CASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("notifyOnResolveCase").getter(getter(UpdateSlackChannelConfigurationRequest::notifyOnResolveCase))
            .setter(setter(Builder::notifyOnResolveCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifyOnResolveCase").build())
            .build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("teamId")
            .getter(getter(UpdateSlackChannelConfigurationRequest::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            CHANNEL_NAME_FIELD, CHANNEL_ROLE_ARN_FIELD, NOTIFY_ON_ADD_CORRESPONDENCE_TO_CASE_FIELD,
            NOTIFY_ON_CASE_SEVERITY_FIELD, NOTIFY_ON_CREATE_OR_REOPEN_CASE_FIELD, NOTIFY_ON_RESOLVE_CASE_FIELD, TEAM_ID_FIELD));

    private final String channelId;

    private final String channelName;

    private final String channelRoleArn;

    private final Boolean notifyOnAddCorrespondenceToCase;

    private final String notifyOnCaseSeverity;

    private final Boolean notifyOnCreateOrReopenCase;

    private final Boolean notifyOnResolveCase;

    private final String teamId;

    private UpdateSlackChannelConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.channelRoleArn = builder.channelRoleArn;
        this.notifyOnAddCorrespondenceToCase = builder.notifyOnAddCorrespondenceToCase;
        this.notifyOnCaseSeverity = builder.notifyOnCaseSeverity;
        this.notifyOnCreateOrReopenCase = builder.notifyOnCreateOrReopenCase;
        this.notifyOnResolveCase = builder.notifyOnResolveCase;
        this.teamId = builder.teamId;
    }

    /**
     * <p>
     * The channel ID in Slack. This ID identifies a channel within a Slack workspace.
     * </p>
     * 
     * @return The channel ID in Slack. This ID identifies a channel within a Slack workspace.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * <p>
     * The Slack channel name that you want to update.
     * </p>
     * 
     * @return The Slack channel name that you want to update.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web Services.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access to the
     * Amazon Web Services Support App</a> in the <i>Amazon Web Services Support User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web
     *         Services. For more information, see <a
     *         href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access to
     *         the Amazon Web Services Support App</a> in the <i>Amazon Web Services Support User Guide</i>.
     */
    public final String channelRoleArn() {
        return channelRoleArn;
    }

    /**
     * <p>
     * Whether you want to get notified when a support case has a new correspondence.
     * </p>
     * 
     * @return Whether you want to get notified when a support case has a new correspondence.
     */
    public final Boolean notifyOnAddCorrespondenceToCase() {
        return notifyOnAddCorrespondenceToCase;
    }

    /**
     * <p>
     * The case severity for a support case that you want to receive notifications.
     * </p>
     * <p>
     * If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
     * <code>true</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>notifyOnAddCorrespondenceToCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnCreateOrReopenCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnResolveCase</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify <code>none</code>, any of the following parameters that you specify in your request must be
     * <code>false</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>notifyOnAddCorrespondenceToCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnCreateOrReopenCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnResolveCase</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you don't specify these parameters in your request, the Amazon Web Services Support App uses the current
     * values by default.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notifyOnCaseSeverity} will return {@link NotificationSeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notifyOnCaseSeverityAsString}.
     * </p>
     * 
     * @return The case severity for a support case that you want to receive notifications.</p>
     *         <p>
     *         If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
     *         <code>true</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>notifyOnAddCorrespondenceToCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnCreateOrReopenCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnResolveCase</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify <code>none</code>, any of the following parameters that you specify in your request must
     *         be <code>false</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>notifyOnAddCorrespondenceToCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnCreateOrReopenCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnResolveCase</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you don't specify these parameters in your request, the Amazon Web Services Support App uses the
     *         current values by default.
     *         </p>
     * @see NotificationSeverityLevel
     */
    public final NotificationSeverityLevel notifyOnCaseSeverity() {
        return NotificationSeverityLevel.fromValue(notifyOnCaseSeverity);
    }

    /**
     * <p>
     * The case severity for a support case that you want to receive notifications.
     * </p>
     * <p>
     * If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
     * <code>true</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>notifyOnAddCorrespondenceToCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnCreateOrReopenCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnResolveCase</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify <code>none</code>, any of the following parameters that you specify in your request must be
     * <code>false</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>notifyOnAddCorrespondenceToCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnCreateOrReopenCase</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notifyOnResolveCase</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you don't specify these parameters in your request, the Amazon Web Services Support App uses the current
     * values by default.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notifyOnCaseSeverity} will return {@link NotificationSeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notifyOnCaseSeverityAsString}.
     * </p>
     * 
     * @return The case severity for a support case that you want to receive notifications.</p>
     *         <p>
     *         If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
     *         <code>true</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>notifyOnAddCorrespondenceToCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnCreateOrReopenCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnResolveCase</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify <code>none</code>, any of the following parameters that you specify in your request must
     *         be <code>false</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>notifyOnAddCorrespondenceToCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnCreateOrReopenCase</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notifyOnResolveCase</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you don't specify these parameters in your request, the Amazon Web Services Support App uses the
     *         current values by default.
     *         </p>
     * @see NotificationSeverityLevel
     */
    public final String notifyOnCaseSeverityAsString() {
        return notifyOnCaseSeverity;
    }

    /**
     * <p>
     * Whether you want to get notified when a support case is created or reopened.
     * </p>
     * 
     * @return Whether you want to get notified when a support case is created or reopened.
     */
    public final Boolean notifyOnCreateOrReopenCase() {
        return notifyOnCreateOrReopenCase;
    }

    /**
     * <p>
     * Whether you want to get notified when a support case is resolved.
     * </p>
     * 
     * @return Whether you want to get notified when a support case is resolved.
     */
    public final Boolean notifyOnResolveCase() {
        return notifyOnResolveCase;
    }

    /**
     * <p>
     * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     * </p>
     * 
     * @return The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
     */
    public final String teamId() {
        return teamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(notifyOnAddCorrespondenceToCase());
        hashCode = 31 * hashCode + Objects.hashCode(notifyOnCaseSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notifyOnCreateOrReopenCase());
        hashCode = 31 * hashCode + Objects.hashCode(notifyOnResolveCase());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSlackChannelConfigurationRequest)) {
            return false;
        }
        UpdateSlackChannelConfigurationRequest other = (UpdateSlackChannelConfigurationRequest) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelRoleArn(), other.channelRoleArn())
                && Objects.equals(notifyOnAddCorrespondenceToCase(), other.notifyOnAddCorrespondenceToCase())
                && Objects.equals(notifyOnCaseSeverityAsString(), other.notifyOnCaseSeverityAsString())
                && Objects.equals(notifyOnCreateOrReopenCase(), other.notifyOnCreateOrReopenCase())
                && Objects.equals(notifyOnResolveCase(), other.notifyOnResolveCase()) && Objects.equals(teamId(), other.teamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSlackChannelConfigurationRequest").add("ChannelId", channelId())
                .add("ChannelName", channelName()).add("ChannelRoleArn", channelRoleArn())
                .add("NotifyOnAddCorrespondenceToCase", notifyOnAddCorrespondenceToCase())
                .add("NotifyOnCaseSeverity", notifyOnCaseSeverityAsString())
                .add("NotifyOnCreateOrReopenCase", notifyOnCreateOrReopenCase())
                .add("NotifyOnResolveCase", notifyOnResolveCase()).add("TeamId", teamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelRoleArn":
            return Optional.ofNullable(clazz.cast(channelRoleArn()));
        case "notifyOnAddCorrespondenceToCase":
            return Optional.ofNullable(clazz.cast(notifyOnAddCorrespondenceToCase()));
        case "notifyOnCaseSeverity":
            return Optional.ofNullable(clazz.cast(notifyOnCaseSeverityAsString()));
        case "notifyOnCreateOrReopenCase":
            return Optional.ofNullable(clazz.cast(notifyOnCreateOrReopenCase()));
        case "notifyOnResolveCase":
            return Optional.ofNullable(clazz.cast(notifyOnResolveCase()));
        case "teamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSlackChannelConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSlackChannelConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportAppRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSlackChannelConfigurationRequest> {
        /**
         * <p>
         * The channel ID in Slack. This ID identifies a channel within a Slack workspace.
         * </p>
         * 
         * @param channelId
         *        The channel ID in Slack. This ID identifies a channel within a Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * <p>
         * The Slack channel name that you want to update.
         * </p>
         * 
         * @param channelName
         *        The Slack channel name that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web
         * Services. For more information, see <a
         * href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access to the
         * Amazon Web Services Support App</a> in the <i>Amazon Web Services Support User Guide</i>.
         * </p>
         * 
         * @param channelRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web
         *        Services. For more information, see <a
         *        href="https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html">Managing access
         *        to the Amazon Web Services Support App</a> in the <i>Amazon Web Services Support User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelRoleArn(String channelRoleArn);

        /**
         * <p>
         * Whether you want to get notified when a support case has a new correspondence.
         * </p>
         * 
         * @param notifyOnAddCorrespondenceToCase
         *        Whether you want to get notified when a support case has a new correspondence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyOnAddCorrespondenceToCase(Boolean notifyOnAddCorrespondenceToCase);

        /**
         * <p>
         * The case severity for a support case that you want to receive notifications.
         * </p>
         * <p>
         * If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
         * <code>true</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>notifyOnAddCorrespondenceToCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnCreateOrReopenCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnResolveCase</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>none</code>, any of the following parameters that you specify in your request must be
         * <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>notifyOnAddCorrespondenceToCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnCreateOrReopenCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnResolveCase</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you don't specify these parameters in your request, the Amazon Web Services Support App uses the current
         * values by default.
         * </p>
         * </note>
         * 
         * @param notifyOnCaseSeverity
         *        The case severity for a support case that you want to receive notifications.</p>
         *        <p>
         *        If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
         *        <code>true</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>notifyOnAddCorrespondenceToCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnCreateOrReopenCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnResolveCase</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>none</code>, any of the following parameters that you specify in your request
         *        must be <code>false</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>notifyOnAddCorrespondenceToCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnCreateOrReopenCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnResolveCase</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you don't specify these parameters in your request, the Amazon Web Services Support App uses the
         *        current values by default.
         *        </p>
         * @see NotificationSeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationSeverityLevel
         */
        Builder notifyOnCaseSeverity(String notifyOnCaseSeverity);

        /**
         * <p>
         * The case severity for a support case that you want to receive notifications.
         * </p>
         * <p>
         * If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
         * <code>true</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>notifyOnAddCorrespondenceToCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnCreateOrReopenCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnResolveCase</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>none</code>, any of the following parameters that you specify in your request must be
         * <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>notifyOnAddCorrespondenceToCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnCreateOrReopenCase</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notifyOnResolveCase</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you don't specify these parameters in your request, the Amazon Web Services Support App uses the current
         * values by default.
         * </p>
         * </note>
         * 
         * @param notifyOnCaseSeverity
         *        The case severity for a support case that you want to receive notifications.</p>
         *        <p>
         *        If you specify <code>high</code> or <code>all</code>, at least one of the following parameters must be
         *        <code>true</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>notifyOnAddCorrespondenceToCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnCreateOrReopenCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnResolveCase</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>none</code>, any of the following parameters that you specify in your request
         *        must be <code>false</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>notifyOnAddCorrespondenceToCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnCreateOrReopenCase</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notifyOnResolveCase</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you don't specify these parameters in your request, the Amazon Web Services Support App uses the
         *        current values by default.
         *        </p>
         * @see NotificationSeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationSeverityLevel
         */
        Builder notifyOnCaseSeverity(NotificationSeverityLevel notifyOnCaseSeverity);

        /**
         * <p>
         * Whether you want to get notified when a support case is created or reopened.
         * </p>
         * 
         * @param notifyOnCreateOrReopenCase
         *        Whether you want to get notified when a support case is created or reopened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyOnCreateOrReopenCase(Boolean notifyOnCreateOrReopenCase);

        /**
         * <p>
         * Whether you want to get notified when a support case is resolved.
         * </p>
         * 
         * @param notifyOnResolveCase
         *        Whether you want to get notified when a support case is resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyOnResolveCase(Boolean notifyOnResolveCase);

        /**
         * <p>
         * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * </p>
         * 
         * @param teamId
         *        The team ID in Slack. This ID uniquely identifies a Slack workspace, such as <code>T012ABCDEFG</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportAppRequest.BuilderImpl implements Builder {
        private String channelId;

        private String channelName;

        private String channelRoleArn;

        private Boolean notifyOnAddCorrespondenceToCase;

        private String notifyOnCaseSeverity;

        private Boolean notifyOnCreateOrReopenCase;

        private Boolean notifyOnResolveCase;

        private String teamId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSlackChannelConfigurationRequest model) {
            super(model);
            channelId(model.channelId);
            channelName(model.channelName);
            channelRoleArn(model.channelRoleArn);
            notifyOnAddCorrespondenceToCase(model.notifyOnAddCorrespondenceToCase);
            notifyOnCaseSeverity(model.notifyOnCaseSeverity);
            notifyOnCreateOrReopenCase(model.notifyOnCreateOrReopenCase);
            notifyOnResolveCase(model.notifyOnResolveCase);
            teamId(model.teamId);
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelRoleArn() {
            return channelRoleArn;
        }

        public final void setChannelRoleArn(String channelRoleArn) {
            this.channelRoleArn = channelRoleArn;
        }

        @Override
        public final Builder channelRoleArn(String channelRoleArn) {
            this.channelRoleArn = channelRoleArn;
            return this;
        }

        public final Boolean getNotifyOnAddCorrespondenceToCase() {
            return notifyOnAddCorrespondenceToCase;
        }

        public final void setNotifyOnAddCorrespondenceToCase(Boolean notifyOnAddCorrespondenceToCase) {
            this.notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase;
        }

        @Override
        public final Builder notifyOnAddCorrespondenceToCase(Boolean notifyOnAddCorrespondenceToCase) {
            this.notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase;
            return this;
        }

        public final String getNotifyOnCaseSeverity() {
            return notifyOnCaseSeverity;
        }

        public final void setNotifyOnCaseSeverity(String notifyOnCaseSeverity) {
            this.notifyOnCaseSeverity = notifyOnCaseSeverity;
        }

        @Override
        public final Builder notifyOnCaseSeverity(String notifyOnCaseSeverity) {
            this.notifyOnCaseSeverity = notifyOnCaseSeverity;
            return this;
        }

        @Override
        public final Builder notifyOnCaseSeverity(NotificationSeverityLevel notifyOnCaseSeverity) {
            this.notifyOnCaseSeverity(notifyOnCaseSeverity == null ? null : notifyOnCaseSeverity.toString());
            return this;
        }

        public final Boolean getNotifyOnCreateOrReopenCase() {
            return notifyOnCreateOrReopenCase;
        }

        public final void setNotifyOnCreateOrReopenCase(Boolean notifyOnCreateOrReopenCase) {
            this.notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase;
        }

        @Override
        public final Builder notifyOnCreateOrReopenCase(Boolean notifyOnCreateOrReopenCase) {
            this.notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase;
            return this;
        }

        public final Boolean getNotifyOnResolveCase() {
            return notifyOnResolveCase;
        }

        public final void setNotifyOnResolveCase(Boolean notifyOnResolveCase) {
            this.notifyOnResolveCase = notifyOnResolveCase;
        }

        @Override
        public final Builder notifyOnResolveCase(Boolean notifyOnResolveCase) {
            this.notifyOnResolveCase = notifyOnResolveCase;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSlackChannelConfigurationRequest build() {
            return new UpdateSlackChannelConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
