/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowType implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowType.Builder, WorkflowType> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(WorkflowType::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String version;

    private WorkflowType(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the workflow type.
     * </p>
     * <note>
     * <p>
     * The combination of workflow type name and version must be unique with in a domain.
     * </p>
     * </note>
     * 
     * @return The name of the workflow type.</p> <note>
     *         <p>
     *         The combination of workflow type name and version must be unique with in a domain.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the workflow type.
     * </p>
     * <note>
     * <p>
     * The combination of workflow type name and version must be unique with in a domain.
     * </p>
     * </note>
     * 
     * @return The version of the workflow type.</p> <note>
     *         <p>
     *         The combination of workflow type name and version must be unique with in a domain.
     *         </p>
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowType)) {
            return false;
        }
        WorkflowType other = (WorkflowType) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowType").add("Name", name()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowType, T> g) {
        return obj -> g.apply((WorkflowType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowType> {
        /**
         * <p>
         * The name of the workflow type.
         * </p>
         * <note>
         * <p>
         * The combination of workflow type name and version must be unique with in a domain.
         * </p>
         * </note>
         * 
         * @param name
         *        The name of the workflow type.</p> <note>
         *        <p>
         *        The combination of workflow type name and version must be unique with in a domain.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the workflow type.
         * </p>
         * <note>
         * <p>
         * The combination of workflow type name and version must be unique with in a domain.
         * </p>
         * </note>
         * 
         * @param version
         *        The version of the workflow type.</p> <note>
         *        <p>
         *        The combination of workflow type name and version must be unique with in a domain.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowType model) {
            name(model.name);
            version(model.version);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public WorkflowType build() {
            return new WorkflowType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
