/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteRecordsRequest extends TimestreamWriteRequest implements
        ToCopyableBuilder<WriteRecordsRequest.Builder, WriteRecordsRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(WriteRecordsRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(WriteRecordsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Record> COMMON_ATTRIBUTES_FIELD = SdkField.<Record> builder(MarshallingType.SDK_POJO)
            .memberName("CommonAttributes").getter(getter(WriteRecordsRequest::commonAttributes))
            .setter(setter(Builder::commonAttributes)).constructor(Record::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonAttributes").build()).build();

    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(WriteRecordsRequest::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, COMMON_ATTRIBUTES_FIELD, RECORDS_FIELD));

    private final String databaseName;

    private final String tableName;

    private final Record commonAttributes;

    private final List<Record> records;

    private WriteRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.commonAttributes = builder.commonAttributes;
        this.records = builder.records;
    }

    /**
     * <p>
     * The name of the Timestream database.
     * </p>
     * 
     * @return The name of the Timestream database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the Timestream table.
     * </p>
     * 
     * @return The name of the Timestream table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A record containing the common measure, dimension, time, and version attributes shared across all the records in
     * the request. The measure and dimension attributes specified will be merged with the measure and dimension
     * attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a
     * <code>ValidationException</code> will be thrown. In other words, a record must contain dimensions with unique
     * names.
     * </p>
     * 
     * @return A record containing the common measure, dimension, time, and version attributes shared across all the
     *         records in the request. The measure and dimension attributes specified will be merged with the measure
     *         and dimension attributes in the records object when the data is written into Timestream. Dimensions may
     *         not overlap, or a <code>ValidationException</code> will be thrown. In other words, a record must contain
     *         dimensions with unique names.
     */
    public final Record commonAttributes() {
        return commonAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of records containing the unique measure, dimension, time, and version attributes for each time series
     * data point.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return An array of records containing the unique measure, dimension, time, and version attributes for each time
     *         series data point.
     */
    public final List<Record> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(commonAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRecordsRequest)) {
            return false;
        }
        WriteRecordsRequest other = (WriteRecordsRequest) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(commonAttributes(), other.commonAttributes()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteRecordsRequest").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("CommonAttributes", commonAttributes()).add("Records", hasRecords() ? records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "CommonAttributes":
            return Optional.ofNullable(clazz.cast(commonAttributes()));
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteRecordsRequest, T> g) {
        return obj -> g.apply((WriteRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteRequest.Builder, SdkPojo, CopyableBuilder<Builder, WriteRecordsRequest> {
        /**
         * <p>
         * The name of the Timestream database.
         * </p>
         * 
         * @param databaseName
         *        The name of the Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the Timestream table.
         * </p>
         * 
         * @param tableName
         *        The name of the Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A record containing the common measure, dimension, time, and version attributes shared across all the records
         * in the request. The measure and dimension attributes specified will be merged with the measure and dimension
         * attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a
         * <code>ValidationException</code> will be thrown. In other words, a record must contain dimensions with unique
         * names.
         * </p>
         * 
         * @param commonAttributes
         *        A record containing the common measure, dimension, time, and version attributes shared across all the
         *        records in the request. The measure and dimension attributes specified will be merged with the measure
         *        and dimension attributes in the records object when the data is written into Timestream. Dimensions
         *        may not overlap, or a <code>ValidationException</code> will be thrown. In other words, a record must
         *        contain dimensions with unique names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonAttributes(Record commonAttributes);

        /**
         * <p>
         * A record containing the common measure, dimension, time, and version attributes shared across all the records
         * in the request. The measure and dimension attributes specified will be merged with the measure and dimension
         * attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a
         * <code>ValidationException</code> will be thrown. In other words, a record must contain dimensions with unique
         * names.
         * </p>
         * This is a convenience method that creates an instance of the {@link Record.Builder} avoiding the need to
         * create one manually via {@link Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Record.Builder#build()} is called immediately and its result is
         * passed to {@link #commonAttributes(Record)}.
         * 
         * @param commonAttributes
         *        a consumer that will call methods on {@link Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commonAttributes(Record)
         */
        default Builder commonAttributes(Consumer<Record.Builder> commonAttributes) {
            return commonAttributes(Record.builder().applyMutation(commonAttributes).build());
        }

        /**
         * <p>
         * An array of records containing the unique measure, dimension, time, and version attributes for each time
         * series data point.
         * </p>
         * 
         * @param records
         *        An array of records containing the unique measure, dimension, time, and version attributes for each
         *        time series data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * An array of records containing the unique measure, dimension, time, and version attributes for each time
         * series data point.
         * </p>
         * 
         * @param records
         *        An array of records containing the unique measure, dimension, time, and version attributes for each
         *        time series data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * An array of records containing the unique measure, dimension, time, and version attributes for each time
         * series data point.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.Record.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.timestreamwrite.model.Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.Record.Builder#build()} is called immediately
         * and its result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamWriteRequest.BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private Record commonAttributes;

        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRecordsRequest model) {
            super(model);
            databaseName(model.databaseName);
            tableName(model.tableName);
            commonAttributes(model.commonAttributes);
            records(model.records);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Record.Builder getCommonAttributes() {
            return commonAttributes != null ? commonAttributes.toBuilder() : null;
        }

        public final void setCommonAttributes(Record.BuilderImpl commonAttributes) {
            this.commonAttributes = commonAttributes != null ? commonAttributes.build() : null;
        }

        @Override
        public final Builder commonAttributes(Record commonAttributes) {
            this.commonAttributes = commonAttributes;
            return this;
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public WriteRecordsRequest build() {
            return new WriteRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
