/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Flag the presence or absence of periods of silence in your Call Analytics transcription output.
 * </p>
 * <p>
 * Rules using <code>NonTalkTimeFilter</code> are designed to match:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The presence of silence at specified periods throughout the call
 * </p>
 * </li>
 * <li>
 * <p>
 * The presence of speech at specified periods throughout the call
 * </p>
 * </li>
 * </ul>
 * <p>
 * See <a href=
 * "https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules"
 * >Rule criteria</a> for usage examples.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NonTalkTimeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<NonTalkTimeFilter.Builder, NonTalkTimeFilter> {
    private static final SdkField<Long> THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Threshold")
            .getter(getter(NonTalkTimeFilter::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<AbsoluteTimeRange> ABSOLUTE_TIME_RANGE_FIELD = SdkField
            .<AbsoluteTimeRange> builder(MarshallingType.SDK_POJO).memberName("AbsoluteTimeRange")
            .getter(getter(NonTalkTimeFilter::absoluteTimeRange)).setter(setter(Builder::absoluteTimeRange))
            .constructor(AbsoluteTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTimeRange").build()).build();

    private static final SdkField<RelativeTimeRange> RELATIVE_TIME_RANGE_FIELD = SdkField
            .<RelativeTimeRange> builder(MarshallingType.SDK_POJO).memberName("RelativeTimeRange")
            .getter(getter(NonTalkTimeFilter::relativeTimeRange)).setter(setter(Builder::relativeTimeRange))
            .constructor(RelativeTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeTimeRange").build()).build();

    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negate").getter(getter(NonTalkTimeFilter::negate)).setter(setter(Builder::negate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD,
            ABSOLUTE_TIME_RANGE_FIELD, RELATIVE_TIME_RANGE_FIELD, NEGATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long threshold;

    private final AbsoluteTimeRange absoluteTimeRange;

    private final RelativeTimeRange relativeTimeRange;

    private final Boolean negate;

    private NonTalkTimeFilter(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.absoluteTimeRange = builder.absoluteTimeRange;
        this.relativeTimeRange = builder.relativeTimeRange;
        this.negate = builder.negate;
    }

    /**
     * <p>
     * Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can flag a
     * silent period that lasts 30000 milliseconds.
     * </p>
     * 
     * @return Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can
     *         flag a silent period that lasts 30000 milliseconds.
     */
    public final Long threshold() {
        return threshold;
    }

    /**
     * <p>
     * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a period
     * of silence. See for more detail.
     * </p>
     * 
     * @return Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a
     *         period of silence. See for more detail.
     */
    public final AbsoluteTimeRange absoluteTimeRange() {
        return absoluteTimeRange;
    }

    /**
     * <p>
     * Allows you to specify a time range (in percentage) in your media file, during which you want to search for a
     * period of silence. See for more detail.
     * </p>
     * 
     * @return Allows you to specify a time range (in percentage) in your media file, during which you want to search
     *         for a period of silence. See for more detail.
     */
    public final RelativeTimeRange relativeTimeRange() {
        return relativeTimeRange;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> to flag periods of speech. Set to <code>FALSE</code> to flag periods of silence
     * </p>
     * 
     * @return Set to <code>TRUE</code> to flag periods of speech. Set to <code>FALSE</code> to flag periods of silence
     */
    public final Boolean negate() {
        return negate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(relativeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(negate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonTalkTimeFilter)) {
            return false;
        }
        NonTalkTimeFilter other = (NonTalkTimeFilter) obj;
        return Objects.equals(threshold(), other.threshold()) && Objects.equals(absoluteTimeRange(), other.absoluteTimeRange())
                && Objects.equals(relativeTimeRange(), other.relativeTimeRange()) && Objects.equals(negate(), other.negate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NonTalkTimeFilter").add("Threshold", threshold()).add("AbsoluteTimeRange", absoluteTimeRange())
                .add("RelativeTimeRange", relativeTimeRange()).add("Negate", negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "AbsoluteTimeRange":
            return Optional.ofNullable(clazz.cast(absoluteTimeRange()));
        case "RelativeTimeRange":
            return Optional.ofNullable(clazz.cast(relativeTimeRange()));
        case "Negate":
            return Optional.ofNullable(clazz.cast(negate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NonTalkTimeFilter, T> g) {
        return obj -> g.apply((NonTalkTimeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NonTalkTimeFilter> {
        /**
         * <p>
         * Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can flag a
         * silent period that lasts 30000 milliseconds.
         * </p>
         * 
         * @param threshold
         *        Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can
         *        flag a silent period that lasts 30000 milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Long threshold);

        /**
         * <p>
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a
         * period of silence. See for more detail.
         * </p>
         * 
         * @param absoluteTimeRange
         *        Allows you to specify a time range (in milliseconds) in your audio, during which you want to search
         *        for a period of silence. See for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange);

        /**
         * <p>
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a
         * period of silence. See for more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AbsoluteTimeRange.Builder} avoiding the
         * need to create one manually via {@link AbsoluteTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbsoluteTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #absoluteTimeRange(AbsoluteTimeRange)}.
         * 
         * @param absoluteTimeRange
         *        a consumer that will call methods on {@link AbsoluteTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #absoluteTimeRange(AbsoluteTimeRange)
         */
        default Builder absoluteTimeRange(Consumer<AbsoluteTimeRange.Builder> absoluteTimeRange) {
            return absoluteTimeRange(AbsoluteTimeRange.builder().applyMutation(absoluteTimeRange).build());
        }

        /**
         * <p>
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for a
         * period of silence. See for more detail.
         * </p>
         * 
         * @param relativeTimeRange
         *        Allows you to specify a time range (in percentage) in your media file, during which you want to search
         *        for a period of silence. See for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeTimeRange(RelativeTimeRange relativeTimeRange);

        /**
         * <p>
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for a
         * period of silence. See for more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelativeTimeRange.Builder} avoiding the
         * need to create one manually via {@link RelativeTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelativeTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #relativeTimeRange(RelativeTimeRange)}.
         * 
         * @param relativeTimeRange
         *        a consumer that will call methods on {@link RelativeTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeTimeRange(RelativeTimeRange)
         */
        default Builder relativeTimeRange(Consumer<RelativeTimeRange.Builder> relativeTimeRange) {
            return relativeTimeRange(RelativeTimeRange.builder().applyMutation(relativeTimeRange).build());
        }

        /**
         * <p>
         * Set to <code>TRUE</code> to flag periods of speech. Set to <code>FALSE</code> to flag periods of silence
         * </p>
         * 
         * @param negate
         *        Set to <code>TRUE</code> to flag periods of speech. Set to <code>FALSE</code> to flag periods of
         *        silence
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negate(Boolean negate);
    }

    static final class BuilderImpl implements Builder {
        private Long threshold;

        private AbsoluteTimeRange absoluteTimeRange;

        private RelativeTimeRange relativeTimeRange;

        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(NonTalkTimeFilter model) {
            threshold(model.threshold);
            absoluteTimeRange(model.absoluteTimeRange);
            relativeTimeRange(model.relativeTimeRange);
            negate(model.negate);
        }

        public final Long getThreshold() {
            return threshold;
        }

        public final void setThreshold(Long threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Long threshold) {
            this.threshold = threshold;
            return this;
        }

        public final AbsoluteTimeRange.Builder getAbsoluteTimeRange() {
            return absoluteTimeRange != null ? absoluteTimeRange.toBuilder() : null;
        }

        public final void setAbsoluteTimeRange(AbsoluteTimeRange.BuilderImpl absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange != null ? absoluteTimeRange.build() : null;
        }

        @Override
        public final Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange;
            return this;
        }

        public final RelativeTimeRange.Builder getRelativeTimeRange() {
            return relativeTimeRange != null ? relativeTimeRange.toBuilder() : null;
        }

        public final void setRelativeTimeRange(RelativeTimeRange.BuilderImpl relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange != null ? relativeTimeRange.build() : null;
        }

        @Override
        public final Builder relativeTimeRange(RelativeTimeRange relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange;
            return this;
        }

        public final Boolean getNegate() {
            return negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        @Override
        public NonTalkTimeFilter build() {
            return new NonTalkTimeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
