/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information related to the type of user authentication that is in use for a file transfer protocol-enabled
 * server's users. A server can have only one method of authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderDetails.Builder, IdentityProviderDetails> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(IdentityProviderDetails::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationRole").getter(getter(IdentityProviderDetails::invocationRole))
            .setter(setter(Builder::invocationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(IdentityProviderDetails::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(IdentityProviderDetails::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            INVOCATION_ROLE_FIELD, DIRECTORY_ID_FIELD, FUNCTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String invocationRole;

    private final String directoryId;

    private final String function;

    private IdentityProviderDetails(BuilderImpl builder) {
        this.url = builder.url;
        this.invocationRole = builder.invocationRole;
        this.directoryId = builder.directoryId;
        this.function = builder.function;
    }

    /**
     * <p>
     * Provides the location of the service endpoint used to authenticate users.
     * </p>
     * 
     * @return Provides the location of the service endpoint used to authenticate users.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * Provides the type of <code>InvocationRole</code> used to authenticate the user account.
     * </p>
     * 
     * @return Provides the type of <code>InvocationRole</code> used to authenticate the user account.
     */
    public final String invocationRole() {
        return invocationRole;
    }

    /**
     * <p>
     * The identifier of the Directory Service directory that you want to stop sharing.
     * </p>
     * 
     * @return The identifier of the Directory Service directory that you want to stop sharing.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The ARN for a lambda function to use for the Identity provider.
     * </p>
     * 
     * @return The ARN for a lambda function to use for the Identity provider.
     */
    public final String function() {
        return function;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRole());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderDetails)) {
            return false;
        }
        IdentityProviderDetails other = (IdentityProviderDetails) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(invocationRole(), other.invocationRole())
                && Objects.equals(directoryId(), other.directoryId()) && Objects.equals(function(), other.function());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderDetails").add("Url", url()).add("InvocationRole", invocationRole())
                .add("DirectoryId", directoryId()).add("Function", function()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "InvocationRole":
            return Optional.ofNullable(clazz.cast(invocationRole()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderDetails, T> g) {
        return obj -> g.apply((IdentityProviderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderDetails> {
        /**
         * <p>
         * Provides the location of the service endpoint used to authenticate users.
         * </p>
         * 
         * @param url
         *        Provides the location of the service endpoint used to authenticate users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * Provides the type of <code>InvocationRole</code> used to authenticate the user account.
         * </p>
         * 
         * @param invocationRole
         *        Provides the type of <code>InvocationRole</code> used to authenticate the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRole(String invocationRole);

        /**
         * <p>
         * The identifier of the Directory Service directory that you want to stop sharing.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the Directory Service directory that you want to stop sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The ARN for a lambda function to use for the Identity provider.
         * </p>
         * 
         * @param function
         *        The ARN for a lambda function to use for the Identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String invocationRole;

        private String directoryId;

        private String function;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderDetails model) {
            url(model.url);
            invocationRole(model.invocationRole);
            directoryId(model.directoryId);
            function(model.function);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getInvocationRole() {
            return invocationRole;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public IdentityProviderDetails build() {
            return new IdentityProviderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
