/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputFileLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<InputFileLocation.Builder, InputFileLocation> {
    private static final SdkField<S3InputFileLocation> S3_FILE_LOCATION_FIELD = SdkField
            .<S3InputFileLocation> builder(MarshallingType.SDK_POJO).memberName("S3FileLocation")
            .getter(getter(InputFileLocation::s3FileLocation)).setter(setter(Builder::s3FileLocation))
            .constructor(S3InputFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3FileLocation").build()).build();

    private static final SdkField<EfsFileLocation> EFS_FILE_LOCATION_FIELD = SdkField
            .<EfsFileLocation> builder(MarshallingType.SDK_POJO).memberName("EfsFileLocation")
            .getter(getter(InputFileLocation::efsFileLocation)).setter(setter(Builder::efsFileLocation))
            .constructor(EfsFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFileLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FILE_LOCATION_FIELD,
            EFS_FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3InputFileLocation s3FileLocation;

    private final EfsFileLocation efsFileLocation;

    private InputFileLocation(BuilderImpl builder) {
        this.s3FileLocation = builder.s3FileLocation;
        this.efsFileLocation = builder.efsFileLocation;
    }

    /**
     * <p>
     * Specifies the details for the S3 file being copied.
     * </p>
     * 
     * @return Specifies the details for the S3 file being copied.
     */
    public final S3InputFileLocation s3FileLocation() {
        return s3FileLocation;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final EfsFileLocation efsFileLocation() {
        return efsFileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3FileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(efsFileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFileLocation)) {
            return false;
        }
        InputFileLocation other = (InputFileLocation) obj;
        return Objects.equals(s3FileLocation(), other.s3FileLocation())
                && Objects.equals(efsFileLocation(), other.efsFileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputFileLocation").add("S3FileLocation", s3FileLocation())
                .add("EfsFileLocation", efsFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3FileLocation":
            return Optional.ofNullable(clazz.cast(s3FileLocation()));
        case "EfsFileLocation":
            return Optional.ofNullable(clazz.cast(efsFileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputFileLocation, T> g) {
        return obj -> g.apply((InputFileLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputFileLocation> {
        /**
         * <p>
         * Specifies the details for the S3 file being copied.
         * </p>
         * 
         * @param s3FileLocation
         *        Specifies the details for the S3 file being copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3FileLocation(S3InputFileLocation s3FileLocation);

        /**
         * <p>
         * Specifies the details for the S3 file being copied.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3InputFileLocation.Builder} avoiding the
         * need to create one manually via {@link S3InputFileLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3InputFileLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #s3FileLocation(S3InputFileLocation)}.
         * 
         * @param s3FileLocation
         *        a consumer that will call methods on {@link S3InputFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3FileLocation(S3InputFileLocation)
         */
        default Builder s3FileLocation(Consumer<S3InputFileLocation.Builder> s3FileLocation) {
            return s3FileLocation(S3InputFileLocation.builder().applyMutation(s3FileLocation).build());
        }

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param efsFileLocation
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileLocation(EfsFileLocation efsFileLocation);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience method that creates an instance of the {@link EfsFileLocation.Builder} avoiding the
         * need to create one manually via {@link EfsFileLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EfsFileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #efsFileLocation(EfsFileLocation)}.
         * 
         * @param efsFileLocation
         *        a consumer that will call methods on {@link EfsFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileLocation(EfsFileLocation)
         */
        default Builder efsFileLocation(Consumer<EfsFileLocation.Builder> efsFileLocation) {
            return efsFileLocation(EfsFileLocation.builder().applyMutation(efsFileLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3InputFileLocation s3FileLocation;

        private EfsFileLocation efsFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFileLocation model) {
            s3FileLocation(model.s3FileLocation);
            efsFileLocation(model.efsFileLocation);
        }

        public final S3InputFileLocation.Builder getS3FileLocation() {
            return s3FileLocation != null ? s3FileLocation.toBuilder() : null;
        }

        public final void setS3FileLocation(S3InputFileLocation.BuilderImpl s3FileLocation) {
            this.s3FileLocation = s3FileLocation != null ? s3FileLocation.build() : null;
        }

        @Override
        public final Builder s3FileLocation(S3InputFileLocation s3FileLocation) {
            this.s3FileLocation = s3FileLocation;
            return this;
        }

        public final EfsFileLocation.Builder getEfsFileLocation() {
            return efsFileLocation != null ? efsFileLocation.toBuilder() : null;
        }

        public final void setEfsFileLocation(EfsFileLocation.BuilderImpl efsFileLocation) {
            this.efsFileLocation = efsFileLocation != null ? efsFileLocation.build() : null;
        }

        @Override
        public final Builder efsFileLocation(EfsFileLocation efsFileLocation) {
            this.efsFileLocation = efsFileLocation;
            return this;
        }

        @Override
        public InputFileLocation build() {
            return new InputFileLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
