/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path match type. Each rule can include only one of the following types of paths.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathMatchType implements SdkPojo, Serializable, ToCopyableBuilder<PathMatchType.Builder, PathMatchType> {
    private static final SdkField<String> EXACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("exact")
            .getter(getter(PathMatchType::exact)).setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(PathMatchType::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exact;

    private final String prefix;

    private final Type type;

    private PathMatchType(BuilderImpl builder) {
        this.exact = builder.exact;
        this.prefix = builder.prefix;
        this.type = builder.type;
    }

    /**
     * <p>
     * An exact match of the path.
     * </p>
     * 
     * @return An exact match of the path.
     */
    public final String exact() {
        return exact;
    }

    /**
     * <p>
     * A prefix match of the path.
     * </p>
     * 
     * @return A prefix match of the path.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exact());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathMatchType)) {
            return false;
        }
        PathMatchType other = (PathMatchType) obj;
        return Objects.equals(exact(), other.exact()) && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathMatchType").add("Exact", exact()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #exact()} initialized to the given value.
     *
     * <p>
     * An exact match of the path.
     * </p>
     * 
     * @param exact
     *        An exact match of the path.
     */
    public static PathMatchType fromExact(String exact) {
        return builder().exact(exact).build();
    }

    /**
     * Create an instance of this class with {@link #prefix()} initialized to the given value.
     *
     * <p>
     * A prefix match of the path.
     * </p>
     * 
     * @param prefix
     *        A prefix match of the path.
     */
    public static PathMatchType fromPrefix(String prefix) {
        return builder().prefix(prefix).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathMatchType, T> g) {
        return obj -> g.apply((PathMatchType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathMatchType> {
        /**
         * <p>
         * An exact match of the path.
         * </p>
         * 
         * @param exact
         *        An exact match of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String exact);

        /**
         * <p>
         * A prefix match of the path.
         * </p>
         * 
         * @param prefix
         *        A prefix match of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String exact;

        private String prefix;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PathMatchType model) {
            exact(model.exact);
            prefix(model.prefix);
        }

        public final String getExact() {
            return exact;
        }

        public final void setExact(String exact) {
            Object oldValue = this.exact;
            this.exact = exact;
            handleUnionValueChange(Type.EXACT, oldValue, this.exact);
        }

        @Override
        public final Builder exact(String exact) {
            Object oldValue = this.exact;
            this.exact = exact;
            handleUnionValueChange(Type.EXACT, oldValue, this.exact);
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            Object oldValue = this.prefix;
            this.prefix = prefix;
            handleUnionValueChange(Type.PREFIX, oldValue, this.prefix);
        }

        @Override
        public final Builder prefix(String prefix) {
            Object oldValue = this.prefix;
            this.prefix = prefix;
            handleUnionValueChange(Type.PREFIX, oldValue, this.prefix);
            return this;
        }

        @Override
        public PathMatchType build() {
            return new PathMatchType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PathMatchType#type()
     */
    public enum Type {
        EXACT,

        PREFIX,

        UNKNOWN_TO_SDK_VERSION
    }
}
