/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * The country from which web requests originate that you want AWS WAF to search for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchConstraint implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoMatchConstraint.Builder, GeoMatchConstraint> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GeoMatchConstraint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(GeoMatchConstraint::valueAsString)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String value;

    private GeoMatchConstraint(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid
     * value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GeoMatchConstraintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only
     *         valid value.
     * @see GeoMatchConstraintType
     */
    public final GeoMatchConstraintType type() {
        return GeoMatchConstraintType.fromValue(type);
    }

    /**
     * <p>
     * The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid
     * value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GeoMatchConstraintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only
     *         valid value.
     * @see GeoMatchConstraintType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The country that you want AWS WAF to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GeoMatchConstraintValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The country that you want AWS WAF to search for.
     * @see GeoMatchConstraintValue
     */
    public final GeoMatchConstraintValue value() {
        return GeoMatchConstraintValue.fromValue(value);
    }

    /**
     * <p>
     * The country that you want AWS WAF to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GeoMatchConstraintValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The country that you want AWS WAF to search for.
     * @see GeoMatchConstraintValue
     */
    public final String valueAsString() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchConstraint)) {
            return false;
        }
        GeoMatchConstraint other = (GeoMatchConstraint) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(valueAsString(), other.valueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoMatchConstraint").add("Type", typeAsString()).add("Value", valueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchConstraint, T> g) {
        return obj -> g.apply((GeoMatchConstraint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchConstraint> {
        /**
         * <p>
         * The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only
         * valid value.
         * </p>
         * 
         * @param type
         *        The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the
         *        only valid value.
         * @see GeoMatchConstraintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchConstraintType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only
         * valid value.
         * </p>
         * 
         * @param type
         *        The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the
         *        only valid value.
         * @see GeoMatchConstraintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchConstraintType
         */
        Builder type(GeoMatchConstraintType type);

        /**
         * <p>
         * The country that you want AWS WAF to search for.
         * </p>
         * 
         * @param value
         *        The country that you want AWS WAF to search for.
         * @see GeoMatchConstraintValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchConstraintValue
         */
        Builder value(String value);

        /**
         * <p>
         * The country that you want AWS WAF to search for.
         * </p>
         * 
         * @param value
         *        The country that you want AWS WAF to search for.
         * @see GeoMatchConstraintValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchConstraintValue
         */
        Builder value(GeoMatchConstraintValue value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchConstraint model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GeoMatchConstraintType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GeoMatchConstraintValue value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        @Override
        public GeoMatchConstraint build() {
            return new GeoMatchConstraint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
