/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies where in a web request to look for <code>TargetString</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldToMatch implements SdkPojo, Serializable, ToCopyableBuilder<FieldToMatch.Builder, FieldToMatch> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(FieldToMatch::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Data")
            .getter(getter(FieldToMatch::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String data;

    private FieldToMatch(BuilderImpl builder) {
        this.type = builder.type;
        this.data = builder.data;
    }

    /**
     * <p>
     * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you
     * can search include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
     * <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in
     * <code>Data</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin
     * to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>,
     * <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
     * character, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>URI</code>: The part of a web request that identifies a resource, for example,
     * <code>/images/daily-ad.jpg</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web
     * server as the HTTP request body, such as data from a form. The request body immediately follows the request
     * headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for
     * inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For
     * more information, see <a>CreateSizeConstraintSet</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i>
     * or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single
     * parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify
     * in <code>TargetString</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MatchFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The part of the web request that you want AWS WAF to search for a specified string. Parts of a request
     *         that you can search include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
     *         <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the
     *         header in <code>Data</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking
     *         the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>,
     *         <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and
     *         <code>PUT</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
     *         character, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>URI</code>: The part of a web request that identifies a resource, for example,
     *         <code>/images/daily-ad.jpg</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BODY</code>: The part of a request that contains any additional data that you want to send to your
     *         web server as the HTTP request body, such as data from a form. The request body immediately follows the
     *         request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to
     *         AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size
     *         constraint set. For more information, see <a>CreateSizeConstraintSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
     *         <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30
     *         characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a
     *         single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern
     *         that you specify in <code>TargetString</code>.
     *         </p>
     *         </li>
     * @see MatchFieldType
     */
    public final MatchFieldType type() {
        return MatchFieldType.fromValue(type);
    }

    /**
     * <p>
     * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you
     * can search include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
     * <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in
     * <code>Data</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin
     * to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>,
     * <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
     * character, if any.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>URI</code>: The part of a web request that identifies a resource, for example,
     * <code>/images/daily-ad.jpg</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web
     * server as the HTTP request body, such as data from a form. The request body immediately follows the request
     * headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for
     * inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For
     * more information, see <a>CreateSizeConstraintSet</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i>
     * or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single
     * parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify
     * in <code>TargetString</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MatchFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The part of the web request that you want AWS WAF to search for a specified string. Parts of a request
     *         that you can search include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
     *         <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the
     *         header in <code>Data</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking
     *         the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>,
     *         <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and
     *         <code>PUT</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
     *         character, if any.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>URI</code>: The part of a web request that identifies a resource, for example,
     *         <code>/images/daily-ad.jpg</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BODY</code>: The part of a request that contains any additional data that you want to send to your
     *         web server as the HTTP request body, such as data from a form. The request body immediately follows the
     *         request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to
     *         AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size
     *         constraint set. For more information, see <a>CreateSizeConstraintSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
     *         <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30
     *         characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a
     *         single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern
     *         that you specify in <code>TargetString</code>.
     *         </p>
     *         </li>
     * @see MatchFieldType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS WAF to
     * search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not case
     * sensitive.
     * </p>
     * <p>
     * When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that you
     * want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter name is not
     * case sensitive.
     * </p>
     * <p>
     * If the value of <code>Type</code> is any other value, omit <code>Data</code>.
     * </p>
     * 
     * @return When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want
     *         AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header
     *         is not case sensitive.</p>
     *         <p>
     *         When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter
     *         that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The
     *         parameter name is not case sensitive.
     *         </p>
     *         <p>
     *         If the value of <code>Type</code> is any other value, omit <code>Data</code>.
     */
    public final String data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToMatch)) {
            return false;
        }
        FieldToMatch other = (FieldToMatch) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldToMatch").add("Type", typeAsString()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldToMatch, T> g) {
        return obj -> g.apply((FieldToMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldToMatch> {
        /**
         * <p>
         * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that
         * you can search include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
         * <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header
         * in <code>Data</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the
         * origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>,
         * <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
         * character, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>URI</code>: The part of a web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web
         * server as the HTTP request body, such as data from a form. The request body immediately follows the request
         * headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for
         * inspection. To allow or block requests based on the length of the body, you can create a size constraint set.
         * For more information, see <a>CreateSizeConstraintSet</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
         * <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single
         * parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you
         * specify in <code>TargetString</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The part of the web request that you want AWS WAF to search for a specified string. Parts of a request
         *        that you can search include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code>
         *        or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of
         *        the header in <code>Data</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking
         *        the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>,
         *        <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and
         *        <code>PUT</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a
         *        <code>?</code> character, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>URI</code>: The part of a web request that identifies a resource, for example,
         *        <code>/images/daily-ad.jpg</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BODY</code>: The part of a request that contains any additional data that you want to send to
         *        your web server as the HTTP request body, such as data from a form. The request body immediately
         *        follows the request headers. Note that only the first <code>8192</code> bytes of the request body are
         *        forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you
         *        can create a size constraint set. For more information, see <a>CreateSizeConstraintSet</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
         *        <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30
         *        characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a
         *        single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern
         *        that you specify in <code>TargetString</code>.
         *        </p>
         *        </li>
         * @see MatchFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchFieldType
         */
        Builder type(String type);

        /**
         * <p>
         * The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that
         * you can search include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or
         * <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header
         * in <code>Data</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the
         * origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>,
         * <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code>
         * character, if any.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>URI</code>: The part of a web request that identifies a resource, for example,
         * <code>/images/daily-ad.jpg</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web
         * server as the HTTP request body, such as data from a form. The request body immediately follows the request
         * headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for
         * inspection. To allow or block requests based on the length of the body, you can create a size constraint set.
         * For more information, see <a>CreateSizeConstraintSet</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
         * <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single
         * parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you
         * specify in <code>TargetString</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The part of the web request that you want AWS WAF to search for a specified string. Parts of a request
         *        that you can search include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code>
         *        or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of
         *        the header in <code>Data</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking
         *        the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>,
         *        <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and
         *        <code>PUT</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a
         *        <code>?</code> character, if any.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>URI</code>: The part of a web request that identifies a resource, for example,
         *        <code>/images/daily-ad.jpg</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BODY</code>: The part of a request that contains any additional data that you want to send to
         *        your web server as the HTTP request body, such as data from a form. The request body immediately
         *        follows the request headers. Note that only the first <code>8192</code> bytes of the request body are
         *        forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you
         *        can create a size constraint set. For more information, see <a>CreateSizeConstraintSet</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as
         *        <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30
         *        characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a
         *        single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern
         *        that you specify in <code>TargetString</code>.
         *        </p>
         *        </li>
         * @see MatchFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchFieldType
         */
        Builder type(MatchFieldType type);

        /**
         * <p>
         * When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS
         * WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not
         * case sensitive.
         * </p>
         * <p>
         * When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that
         * you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter
         * name is not case sensitive.
         * </p>
         * <p>
         * If the value of <code>Type</code> is any other value, omit <code>Data</code>.
         * </p>
         * 
         * @param data
         *        When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want
         *        AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the
         *        header is not case sensitive.</p>
         *        <p>
         *        When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter
         *        that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The
         *        parameter name is not case sensitive.
         *        </p>
         *        <p>
         *        If the value of <code>Type</code> is any other value, omit <code>Data</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToMatch model) {
            type(model.type);
            data(model.data);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MatchFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public FieldToMatch build() {
            return new FieldToMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
