/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
 * </p>
 * <p>
 * Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you
 * want the Bot Control rule group to use.
 * </p>
 * <p>
 * For example specifications, see the examples section of <a>CreateWebACL</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedRuleGroupConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedRuleGroupConfig.Builder, ManagedRuleGroupConfig> {
    private static final SdkField<String> LOGIN_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoginPath").getter(getter(ManagedRuleGroupConfig::loginPath)).setter(setter(Builder::loginPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginPath").build()).build();

    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(ManagedRuleGroupConfig::payloadTypeAsString))
            .setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final SdkField<UsernameField> USERNAME_FIELD_FIELD = SdkField
            .<UsernameField> builder(MarshallingType.SDK_POJO).memberName("UsernameField")
            .getter(getter(ManagedRuleGroupConfig::usernameField)).setter(setter(Builder::usernameField))
            .constructor(UsernameField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameField").build()).build();

    private static final SdkField<PasswordField> PASSWORD_FIELD_FIELD = SdkField
            .<PasswordField> builder(MarshallingType.SDK_POJO).memberName("PasswordField")
            .getter(getter(ManagedRuleGroupConfig::passwordField)).setter(setter(Builder::passwordField))
            .constructor(PasswordField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordField").build()).build();

    private static final SdkField<AWSManagedRulesBotControlRuleSet> AWS_MANAGED_RULES_BOT_CONTROL_RULE_SET_FIELD = SdkField
            .<AWSManagedRulesBotControlRuleSet> builder(MarshallingType.SDK_POJO)
            .memberName("AWSManagedRulesBotControlRuleSet")
            .getter(getter(ManagedRuleGroupConfig::awsManagedRulesBotControlRuleSet))
            .setter(setter(Builder::awsManagedRulesBotControlRuleSet))
            .constructor(AWSManagedRulesBotControlRuleSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSManagedRulesBotControlRuleSet")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIN_PATH_FIELD,
            PAYLOAD_TYPE_FIELD, USERNAME_FIELD_FIELD, PASSWORD_FIELD_FIELD, AWS_MANAGED_RULES_BOT_CONTROL_RULE_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loginPath;

    private final String payloadType;

    private final UsernameField usernameField;

    private final PasswordField passwordField;

    private final AWSManagedRulesBotControlRuleSet awsManagedRulesBotControlRuleSet;

    private ManagedRuleGroupConfig(BuilderImpl builder) {
        this.loginPath = builder.loginPath;
        this.payloadType = builder.payloadType;
        this.usernameField = builder.usernameField;
        this.passwordField = builder.passwordField;
        this.awsManagedRulesBotControlRuleSet = builder.awsManagedRulesBotControlRuleSet;
    }

    /**
     * <p>
     * The path of the login endpoint for your application. For example, for the URL
     * <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>.
     * </p>
     * 
     * @return The path of the login endpoint for your application. For example, for the URL
     *         <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>.
     */
    public final String loginPath() {
        return loginPath;
    }

    /**
     * <p>
     * The payload type for your login endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your login endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final PayloadType payloadType() {
        return PayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * The payload type for your login endpoint, either JSON or form encoded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The payload type for your login endpoint, either JSON or form encoded.
     * @see PayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    /**
     * <p>
     * Details about your login page username field.
     * </p>
     * 
     * @return Details about your login page username field.
     */
    public final UsernameField usernameField() {
        return usernameField;
    }

    /**
     * <p>
     * Details about your login page password field.
     * </p>
     * 
     * @return Details about your login page password field.
     */
    public final PasswordField passwordField() {
        return passwordField;
    }

    /**
     * <p>
     * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level
     * that you want to use. For information about using the Bot Control managed rule group, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
     * rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF Bot
     * Control</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection
     *         level that you want to use. For information about using the Bot Control managed rule group, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
     *         Control rule group</a> and <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF Bot Control</a> in
     *         the <i>WAF Developer Guide</i>.
     */
    public final AWSManagedRulesBotControlRuleSet awsManagedRulesBotControlRuleSet() {
        return awsManagedRulesBotControlRuleSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loginPath());
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usernameField());
        hashCode = 31 * hashCode + Objects.hashCode(passwordField());
        hashCode = 31 * hashCode + Objects.hashCode(awsManagedRulesBotControlRuleSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleGroupConfig)) {
            return false;
        }
        ManagedRuleGroupConfig other = (ManagedRuleGroupConfig) obj;
        return Objects.equals(loginPath(), other.loginPath())
                && Objects.equals(payloadTypeAsString(), other.payloadTypeAsString())
                && Objects.equals(usernameField(), other.usernameField())
                && Objects.equals(passwordField(), other.passwordField())
                && Objects.equals(awsManagedRulesBotControlRuleSet(), other.awsManagedRulesBotControlRuleSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedRuleGroupConfig").add("LoginPath", loginPath()).add("PayloadType", payloadTypeAsString())
                .add("UsernameField", usernameField()).add("PasswordField", passwordField())
                .add("AWSManagedRulesBotControlRuleSet", awsManagedRulesBotControlRuleSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoginPath":
            return Optional.ofNullable(clazz.cast(loginPath()));
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        case "UsernameField":
            return Optional.ofNullable(clazz.cast(usernameField()));
        case "PasswordField":
            return Optional.ofNullable(clazz.cast(passwordField()));
        case "AWSManagedRulesBotControlRuleSet":
            return Optional.ofNullable(clazz.cast(awsManagedRulesBotControlRuleSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleGroupConfig, T> g) {
        return obj -> g.apply((ManagedRuleGroupConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedRuleGroupConfig> {
        /**
         * <p>
         * The path of the login endpoint for your application. For example, for the URL
         * <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>.
         * </p>
         * 
         * @param loginPath
         *        The path of the login endpoint for your application. For example, for the URL
         *        <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginPath(String loginPath);

        /**
         * <p>
         * The payload type for your login endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your login endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * The payload type for your login endpoint, either JSON or form encoded.
         * </p>
         * 
         * @param payloadType
         *        The payload type for your login endpoint, either JSON or form encoded.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder payloadType(PayloadType payloadType);

        /**
         * <p>
         * Details about your login page username field.
         * </p>
         * 
         * @param usernameField
         *        Details about your login page username field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameField(UsernameField usernameField);

        /**
         * <p>
         * Details about your login page username field.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsernameField.Builder} avoiding the need
         * to create one manually via {@link UsernameField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernameField.Builder#build()} is called immediately and its
         * result is passed to {@link #usernameField(UsernameField)}.
         * 
         * @param usernameField
         *        a consumer that will call methods on {@link UsernameField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usernameField(UsernameField)
         */
        default Builder usernameField(Consumer<UsernameField.Builder> usernameField) {
            return usernameField(UsernameField.builder().applyMutation(usernameField).build());
        }

        /**
         * <p>
         * Details about your login page password field.
         * </p>
         * 
         * @param passwordField
         *        Details about your login page password field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordField(PasswordField passwordField);

        /**
         * <p>
         * Details about your login page password field.
         * </p>
         * This is a convenience method that creates an instance of the {@link PasswordField.Builder} avoiding the need
         * to create one manually via {@link PasswordField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PasswordField.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordField(PasswordField)}.
         * 
         * @param passwordField
         *        a consumer that will call methods on {@link PasswordField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordField(PasswordField)
         */
        default Builder passwordField(Consumer<PasswordField.Builder> passwordField) {
            return passwordField(PasswordField.builder().applyMutation(passwordField).build());
        }

        /**
         * <p>
         * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection
         * level that you want to use. For information about using the Bot Control managed rule group, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
         * rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF
         * Bot Control</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param awsManagedRulesBotControlRuleSet
         *        Additional configuration for using the Bot Control managed rule group. Use this to specify the
         *        inspection level that you want to use. For information about using the Bot Control managed rule group,
         *        see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot
         *        Control rule group</a> and <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF Bot Control</a>
         *        in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSet awsManagedRulesBotControlRuleSet);

        /**
         * <p>
         * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection
         * level that you want to use. For information about using the Bot Control managed rule group, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">WAF Bot Control
         * rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">WAF
         * Bot Control</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AWSManagedRulesBotControlRuleSet.Builder}
         * avoiding the need to create one manually via {@link AWSManagedRulesBotControlRuleSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AWSManagedRulesBotControlRuleSet.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSet)}.
         * 
         * @param awsManagedRulesBotControlRuleSet
         *        a consumer that will call methods on {@link AWSManagedRulesBotControlRuleSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSet)
         */
        default Builder awsManagedRulesBotControlRuleSet(
                Consumer<AWSManagedRulesBotControlRuleSet.Builder> awsManagedRulesBotControlRuleSet) {
            return awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSet.builder()
                    .applyMutation(awsManagedRulesBotControlRuleSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String loginPath;

        private String payloadType;

        private UsernameField usernameField;

        private PasswordField passwordField;

        private AWSManagedRulesBotControlRuleSet awsManagedRulesBotControlRuleSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleGroupConfig model) {
            loginPath(model.loginPath);
            payloadType(model.payloadType);
            usernameField(model.usernameField);
            passwordField(model.passwordField);
            awsManagedRulesBotControlRuleSet(model.awsManagedRulesBotControlRuleSet);
        }

        public final String getLoginPath() {
            return loginPath;
        }

        public final void setLoginPath(String loginPath) {
            this.loginPath = loginPath;
        }

        @Override
        public final Builder loginPath(String loginPath) {
            this.loginPath = loginPath;
            return this;
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(PayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final UsernameField.Builder getUsernameField() {
            return usernameField != null ? usernameField.toBuilder() : null;
        }

        public final void setUsernameField(UsernameField.BuilderImpl usernameField) {
            this.usernameField = usernameField != null ? usernameField.build() : null;
        }

        @Override
        public final Builder usernameField(UsernameField usernameField) {
            this.usernameField = usernameField;
            return this;
        }

        public final PasswordField.Builder getPasswordField() {
            return passwordField != null ? passwordField.toBuilder() : null;
        }

        public final void setPasswordField(PasswordField.BuilderImpl passwordField) {
            this.passwordField = passwordField != null ? passwordField.build() : null;
        }

        @Override
        public final Builder passwordField(PasswordField passwordField) {
            this.passwordField = passwordField;
            return this;
        }

        public final AWSManagedRulesBotControlRuleSet.Builder getAwsManagedRulesBotControlRuleSet() {
            return awsManagedRulesBotControlRuleSet != null ? awsManagedRulesBotControlRuleSet.toBuilder() : null;
        }

        public final void setAwsManagedRulesBotControlRuleSet(
                AWSManagedRulesBotControlRuleSet.BuilderImpl awsManagedRulesBotControlRuleSet) {
            this.awsManagedRulesBotControlRuleSet = awsManagedRulesBotControlRuleSet != null ? awsManagedRulesBotControlRuleSet
                    .build() : null;
        }

        @Override
        public final Builder awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSet awsManagedRulesBotControlRuleSet) {
            this.awsManagedRulesBotControlRuleSet = awsManagedRulesBotControlRuleSet;
            return this;
        }

        @Override
        public ManagedRuleGroupConfig build() {
            return new ManagedRuleGroupConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
