/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Action setting to use in the place of a rule action that is configured inside the rule group. You specify one
 * override for each rule whose action you want to change.
 * </p>
 * <p>
 * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then
 * monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also
 * permanently override some or all actions, to modify how the rule group manages your web traffic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleActionOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleActionOverride.Builder, RuleActionOverride> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RuleActionOverride::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RuleAction> ACTION_TO_USE_FIELD = SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
            .memberName("ActionToUse").getter(getter(RuleActionOverride::actionToUse)).setter(setter(Builder::actionToUse))
            .constructor(RuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionToUse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ACTION_TO_USE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final RuleAction actionToUse;

    private RuleActionOverride(BuilderImpl builder) {
        this.name = builder.name;
        this.actionToUse = builder.actionToUse;
    }

    /**
     * <p>
     * The name of the rule to override.
     * </p>
     * 
     * @return The name of the rule to override.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The override action to use, in place of the configured action of the rule in the rule group.
     * </p>
     * 
     * @return The override action to use, in place of the configured action of the rule in the rule group.
     */
    public final RuleAction actionToUse() {
        return actionToUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(actionToUse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleActionOverride)) {
            return false;
        }
        RuleActionOverride other = (RuleActionOverride) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(actionToUse(), other.actionToUse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleActionOverride").add("Name", name()).add("ActionToUse", actionToUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ActionToUse":
            return Optional.ofNullable(clazz.cast(actionToUse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleActionOverride, T> g) {
        return obj -> g.apply((RuleActionOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleActionOverride> {
        /**
         * <p>
         * The name of the rule to override.
         * </p>
         * 
         * @param name
         *        The name of the rule to override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The override action to use, in place of the configured action of the rule in the rule group.
         * </p>
         * 
         * @param actionToUse
         *        The override action to use, in place of the configured action of the rule in the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionToUse(RuleAction actionToUse);

        /**
         * <p>
         * The override action to use, in place of the configured action of the rule in the rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleAction.Builder} avoiding the need to
         * create one manually via {@link RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleAction.Builder#build()} is called immediately and its result
         * is passed to {@link #actionToUse(RuleAction)}.
         * 
         * @param actionToUse
         *        a consumer that will call methods on {@link RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionToUse(RuleAction)
         */
        default Builder actionToUse(Consumer<RuleAction.Builder> actionToUse) {
            return actionToUse(RuleAction.builder().applyMutation(actionToUse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private RuleAction actionToUse;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleActionOverride model) {
            name(model.name);
            actionToUse(model.actionToUse);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleAction.Builder getActionToUse() {
            return actionToUse != null ? actionToUse.toBuilder() : null;
        }

        public final void setActionToUse(RuleAction.BuilderImpl actionToUse) {
            this.actionToUse = actionToUse != null ? actionToUse.build() : null;
        }

        @Override
        public final Builder actionToUse(RuleAction actionToUse) {
            this.actionToUse = actionToUse;
            return this;
        }

        @Override
        public RuleActionOverride build() {
            return new RuleActionOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
