/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A choice available to answer question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Choice implements SdkPojo, Serializable, ToCopyableBuilder<Choice.Builder, Choice> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(Choice::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Choice::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Choice::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ChoiceContent> HELPFUL_RESOURCE_FIELD = SdkField
            .<ChoiceContent> builder(MarshallingType.SDK_POJO).memberName("HelpfulResource")
            .getter(getter(Choice::helpfulResource)).setter(setter(Builder::helpfulResource)).constructor(ChoiceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResource").build()).build();

    private static final SdkField<ChoiceContent> IMPROVEMENT_PLAN_FIELD = SdkField
            .<ChoiceContent> builder(MarshallingType.SDK_POJO).memberName("ImprovementPlan")
            .getter(getter(Choice::improvementPlan)).setter(setter(Builder::improvementPlan)).constructor(ChoiceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlan").build()).build();

    private static final SdkField<List<AdditionalResources>> ADDITIONAL_RESOURCES_FIELD = SdkField
            .<List<AdditionalResources>> builder(MarshallingType.LIST)
            .memberName("AdditionalResources")
            .getter(getter(Choice::additionalResources))
            .setter(setter(Builder::additionalResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalResources> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalResources::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, HELPFUL_RESOURCE_FIELD, IMPROVEMENT_PLAN_FIELD, ADDITIONAL_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String choiceId;

    private final String title;

    private final String description;

    private final ChoiceContent helpfulResource;

    private final ChoiceContent improvementPlan;

    private final List<AdditionalResources> additionalResources;

    private Choice(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.title = builder.title;
        this.description = builder.description;
        this.helpfulResource = builder.helpfulResource;
        this.improvementPlan = builder.improvementPlan;
        this.additionalResources = builder.additionalResources;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * Returns the value of the Title property for this object.
     * 
     * @return The value of the Title property for this object.
     */
    public final String title() {
        return title;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The choice level helpful resource.
     * </p>
     * 
     * @return The choice level helpful resource.
     */
    public final ChoiceContent helpfulResource() {
        return helpfulResource;
    }

    /**
     * <p>
     * The choice level improvement plan.
     * </p>
     * 
     * @return The choice level improvement plan.
     */
    public final ChoiceContent improvementPlan() {
        return improvementPlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalResources() {
        return additionalResources != null && !(additionalResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional resources for a choice. A choice can have up to two additional resources: one of type
     * <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalResources} method.
     * </p>
     * 
     * @return The additional resources for a choice. A choice can have up to two additional resources: one of type
     *         <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
     */
    public final List<AdditionalResources> additionalResources() {
        return additionalResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(helpfulResource());
        hashCode = 31 * hashCode + Objects.hashCode(improvementPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalResources() ? additionalResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Choice)) {
            return false;
        }
        Choice other = (Choice) obj;
        return Objects.equals(choiceId(), other.choiceId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description())
                && Objects.equals(helpfulResource(), other.helpfulResource())
                && Objects.equals(improvementPlan(), other.improvementPlan())
                && hasAdditionalResources() == other.hasAdditionalResources()
                && Objects.equals(additionalResources(), other.additionalResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Choice").add("ChoiceId", choiceId()).add("Title", title()).add("Description", description())
                .add("HelpfulResource", helpfulResource()).add("ImprovementPlan", improvementPlan())
                .add("AdditionalResources", hasAdditionalResources() ? additionalResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HelpfulResource":
            return Optional.ofNullable(clazz.cast(helpfulResource()));
        case "ImprovementPlan":
            return Optional.ofNullable(clazz.cast(improvementPlan()));
        case "AdditionalResources":
            return Optional.ofNullable(clazz.cast(additionalResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Choice, T> g) {
        return obj -> g.apply((Choice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Choice> {
        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * Sets the value of the Title property for this object.
         *
         * @param title
         *        The new value for the Title property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The choice level helpful resource.
         * </p>
         * 
         * @param helpfulResource
         *        The choice level helpful resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder helpfulResource(ChoiceContent helpfulResource);

        /**
         * <p>
         * The choice level helpful resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChoiceContent.Builder} avoiding the need
         * to create one manually via {@link ChoiceContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChoiceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #helpfulResource(ChoiceContent)}.
         * 
         * @param helpfulResource
         *        a consumer that will call methods on {@link ChoiceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #helpfulResource(ChoiceContent)
         */
        default Builder helpfulResource(Consumer<ChoiceContent.Builder> helpfulResource) {
            return helpfulResource(ChoiceContent.builder().applyMutation(helpfulResource).build());
        }

        /**
         * <p>
         * The choice level improvement plan.
         * </p>
         * 
         * @param improvementPlan
         *        The choice level improvement plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementPlan(ChoiceContent improvementPlan);

        /**
         * <p>
         * The choice level improvement plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChoiceContent.Builder} avoiding the need
         * to create one manually via {@link ChoiceContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChoiceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #improvementPlan(ChoiceContent)}.
         * 
         * @param improvementPlan
         *        a consumer that will call methods on {@link ChoiceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #improvementPlan(ChoiceContent)
         */
        default Builder improvementPlan(Consumer<ChoiceContent.Builder> improvementPlan) {
            return improvementPlan(ChoiceContent.builder().applyMutation(improvementPlan).build());
        }

        /**
         * <p>
         * The additional resources for a choice. A choice can have up to two additional resources: one of type
         * <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
         * </p>
         * 
         * @param additionalResources
         *        The additional resources for a choice. A choice can have up to two additional resources: one of type
         *        <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResources(Collection<AdditionalResources> additionalResources);

        /**
         * <p>
         * The additional resources for a choice. A choice can have up to two additional resources: one of type
         * <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
         * </p>
         * 
         * @param additionalResources
         *        The additional resources for a choice. A choice can have up to two additional resources: one of type
         *        <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalResources(AdditionalResources... additionalResources);

        /**
         * <p>
         * The additional resources for a choice. A choice can have up to two additional resources: one of type
         * <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.AdditionalResources.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.AdditionalResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.AdditionalResources.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalResources(List<AdditionalResources>)}.
         * 
         * @param additionalResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.AdditionalResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalResources(java.util.Collection<AdditionalResources>)
         */
        Builder additionalResources(Consumer<AdditionalResources.Builder>... additionalResources);
    }

    static final class BuilderImpl implements Builder {
        private String choiceId;

        private String title;

        private String description;

        private ChoiceContent helpfulResource;

        private ChoiceContent improvementPlan;

        private List<AdditionalResources> additionalResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Choice model) {
            choiceId(model.choiceId);
            title(model.title);
            description(model.description);
            helpfulResource(model.helpfulResource);
            improvementPlan(model.improvementPlan);
            additionalResources(model.additionalResources);
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ChoiceContent.Builder getHelpfulResource() {
            return helpfulResource != null ? helpfulResource.toBuilder() : null;
        }

        public final void setHelpfulResource(ChoiceContent.BuilderImpl helpfulResource) {
            this.helpfulResource = helpfulResource != null ? helpfulResource.build() : null;
        }

        @Override
        public final Builder helpfulResource(ChoiceContent helpfulResource) {
            this.helpfulResource = helpfulResource;
            return this;
        }

        public final ChoiceContent.Builder getImprovementPlan() {
            return improvementPlan != null ? improvementPlan.toBuilder() : null;
        }

        public final void setImprovementPlan(ChoiceContent.BuilderImpl improvementPlan) {
            this.improvementPlan = improvementPlan != null ? improvementPlan.build() : null;
        }

        @Override
        public final Builder improvementPlan(ChoiceContent improvementPlan) {
            this.improvementPlan = improvementPlan;
            return this;
        }

        public final List<AdditionalResources.Builder> getAdditionalResources() {
            List<AdditionalResources.Builder> result = AdditionalResourcesListCopier.copyToBuilder(this.additionalResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalResources(Collection<AdditionalResources.BuilderImpl> additionalResources) {
            this.additionalResources = AdditionalResourcesListCopier.copyFromBuilder(additionalResources);
        }

        @Override
        public final Builder additionalResources(Collection<AdditionalResources> additionalResources) {
            this.additionalResources = AdditionalResourcesListCopier.copy(additionalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResources(AdditionalResources... additionalResources) {
            additionalResources(Arrays.asList(additionalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResources(Consumer<AdditionalResources.Builder>... additionalResources) {
            additionalResources(Stream.of(additionalResources).map(c -> AdditionalResources.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Choice build() {
            return new Choice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
